<?php
session_start();
include 'config_path.php'; 

// --- KONFIGURASI ENKRIPSI ---
define('ENCRYPTION_KEY', 'Ezidcode_MyS3cr3tKey_f0r_L1c3n5e'); 
define('ENCRYPTION_IV',  'MyS3cur316CharIV'); 
// ----------------------------

header('Content-Type: application/json');

$action = $_POST['action'] ?? $_GET['action'] ?? '';

// ==========================================
// BAGIAN 1: FITUR DASAR (LAGU & PLAYLIST)
// ==========================================

// --- 1. SYNC FILE ---
if ($action === 'sync_files') {
    $input = json_decode($_POST['files'], true);
    if (!is_array($input)) { echo json_encode(['status'=>'error']); exit; }

    $added = 0;
    foreach ($input as $filename) {
        $safeTitle = mysqli_real_escape_string($conn, $filename);
        $check = mysqli_query($conn, "SELECT id FROM songs WHERE title = '$safeTitle'");
        if (mysqli_num_rows($check) == 0) {
            $sql = "INSERT INTO songs (title, filepath, filetype) VALUES ('$safeTitle', '$safeTitle', 'local')";
            if(mysqli_query($conn, $sql)) $added++;
        }
    }
    echo json_encode(['status' => 'success', 'added' => $added]);
    exit;
}

// --- 2. GET LIBRARY ---
if ($action === 'get_all_songs') {
    $q = mysqli_query($conn, "SELECT id, title FROM songs ORDER BY title ASC");
    $data = [];
    while($row = mysqli_fetch_assoc($q)) $data[] = $row;
    echo json_encode($data);
    exit;
}

// --- 3. SAVE PLAYLIST (UPDATE TYPE) ---
if ($action === 'save_playlist') {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $type = mysqli_real_escape_string($conn, $_POST['type'] ?? 'local');
    $items = json_decode($_POST['songs'], true);
    
    if(mysqli_query($conn, "INSERT INTO playlists (name, type) VALUES ('$name', '$type')")) {
        $playlistId = mysqli_insert_id($conn);
        foreach ($items as $idx => $item) {
            $songId = 0;
            if (is_array($item) && isset($item['videoId'])) {
                $title = mysqli_real_escape_string($conn, $item['title']);
                $vid = mysqli_real_escape_string($conn, $item['videoId']);
                $check = mysqli_query($conn, "SELECT id FROM songs WHERE filepath = '$vid' AND filetype='youtube' LIMIT 1");
                if ($row = mysqli_fetch_assoc($check)) $songId = $row['id'];
                else {
                    mysqli_query($conn, "INSERT INTO songs (title, filepath, filetype) VALUES ('$title', '$vid', 'youtube')");
                    $songId = mysqli_insert_id($conn);
                }
            } else {
                $titleStr = is_array($item) ? $item['title'] : $item;
                $safeTitle = mysqli_real_escape_string($conn, $titleStr);
                $qSong = mysqli_query($conn, "SELECT id FROM songs WHERE title = '$safeTitle' AND filetype != 'youtube' LIMIT 1");
                if($row = mysqli_fetch_assoc($qSong)) $songId = $row['id'];
            }
            if ($songId > 0) mysqli_query($conn, "INSERT INTO playlist_items (playlist_id, song_id, sort_order) VALUES ($playlistId, $songId, $idx)");
        }
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'msg' => mysqli_error($conn)]);
    }
    exit;
}

// --- 4. GET PLAYLISTS ---
if ($action === 'get_playlists') {
    $type = mysqli_real_escape_string($conn, $_GET['type'] ?? 'local');
    $q = mysqli_query($conn, "SELECT * FROM playlists WHERE type = '$type' ORDER BY created_at DESC");
    $data = [];
    while($row = mysqli_fetch_assoc($q)) $data[] = $row;
    echo json_encode($data);
    exit;
}

// --- 5. LOAD PLAYLIST ITEMS ---
if ($action === 'load_playlist_items') {
    $pid = (int)$_GET['id'];
    $sql = "SELECT s.title, s.filepath, s.filetype FROM playlist_items pi JOIN songs s ON pi.song_id = s.id WHERE pi.playlist_id = $pid ORDER BY pi.sort_order ASC";
    $q = mysqli_query($conn, $sql);
    $data = [];
    while($row = mysqli_fetch_assoc($q)) {
        $data[] = [
            'title' => $row['title'],
            'videoId' => $row['filepath'], 
            'type' => $row['filetype']
        ];
    }
    echo json_encode($data);
    exit;
}

// --- 6. SETTINGS & LISENSI ---
if ($action === 'get_settings') {
    $q = mysqli_query($conn, "SELECT * FROM settings");
    $settings = [];
    while($row = mysqli_fetch_assoc($q)) $settings[$row['setting_key']] = $row['setting_value'];
    echo json_encode($settings);
    exit;
}

if ($action === 'save_setting') {
    $key = mysqli_real_escape_string($conn, $_POST['key']);
    $val = mysqli_real_escape_string($conn, $_POST['val']);
    $sql = "INSERT INTO settings (setting_key, setting_value) VALUES ('$key', '$val') ON DUPLICATE KEY UPDATE setting_value = '$val'";
    mysqli_query($conn, $sql);
    echo json_encode(['status'=>'success']);
    exit;
}

if ($action === 'check_license') {
    $q = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'license_key'");
    $row = mysqli_fetch_assoc($q);
    $key = $row['setting_value'] ?? '';

    if (empty($key)) { echo json_encode(['status'=>'invalid', 'msg'=>'Kosong']); exit; }

    $decrypted = openssl_decrypt(base64_decode($key), 'aes-256-cbc', ENCRYPTION_KEY, 0, ENCRYPTION_IV);
    
    if (!$decrypted) { echo json_encode(['status'=>'invalid', 'msg'=>'Format Salah']); exit; }
    
    $parts = explode('|', $decrypted);
    if(count($parts) != 2) { echo json_encode(['status'=>'invalid', 'msg'=>'Data Rusak']); exit; }
    
    $expiry = $parts[1];
    if (date('Y-m-d') > $expiry) {
        echo json_encode(['status'=>'invalid', 'msg'=>'Kadaluarsa']);
    } else {
        echo json_encode(['status'=>'valid', 'expiry'=>$expiry]);
    }
    exit;
}

if ($action === 'change_password') {
    $user = $_SESSION['user']; 
    $newPass = mysqli_real_escape_string($conn, $_POST['new_pass']);
    if(empty($newPass)) { echo json_encode(['status'=>'error', 'msg'=>'Password kosong']); exit; }
    $sql = "UPDATE users SET password = '$newPass' WHERE username = '$user'";
    if(mysqli_query($conn, $sql)) echo json_encode(['status'=>'success']);
    else echo json_encode(['status'=>'error', 'msg'=>mysqli_error($conn)]);
    exit;
}

// --- 7. RESET DATA ---
if ($action === 'reset_data') {
    mysqli_query($conn, "SET FOREIGN_KEY_CHECKS = 0");
    mysqli_query($conn, "TRUNCATE TABLE playlist_items");
    mysqli_query($conn, "TRUNCATE TABLE playlists"); 
    mysqli_query($conn, "TRUNCATE TABLE songs"); 
    mysqli_query($conn, "TRUNCATE TABLE billing_logs"); // Reset log keuangan juga
    mysqli_query($conn, "SET FOREIGN_KEY_CHECKS = 1");
    echo json_encode(['status' => 'success']);
    exit;
}

// --- 8. AUTH ---
if ($action === 'login_check') {
    $u = mysqli_real_escape_string($conn, $_POST['username']);
    $p = $_POST['password'];
    $q = mysqli_query($conn, "SELECT * FROM users WHERE username='$u' AND password='$p'");
    if (mysqli_num_rows($q) > 0) {
        $_SESSION['user'] = $u;
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'fail']);
    }
    exit;
}

if ($action === 'logout') {
    session_destroy();
    echo json_encode(['status' => 'success']);
    exit;
}

// --- 9 & 10. SUBTITLE ---
if ($action === 'save_generated_subtitle') {
    $id = (int)$_POST['id'];
    $vtt_content = $_POST['content'];
    if ($id <= 0 || empty($vtt_content)) { echo json_encode(['status'=>'error', 'msg'=>'Data kosong']); exit; }
    $q = mysqli_query($conn, "SELECT filepath FROM songs WHERE id = $id");
    if ($row = mysqli_fetch_assoc($q)) {
        $base_folder = rtrim($SOURCE_FOLDER, '/\\') . DIRECTORY_SEPARATOR;
        $mp4_path = $base_folder . $row['filepath'];
        $vtt_path = preg_replace('/\.[^.]+$/', '.vtt', $mp4_path);
        if (file_put_contents($vtt_path, $vtt_content)) echo json_encode(['status'=>'success']);
        else echo json_encode(['status'=>'error', 'msg'=>'Gagal menulis file']);
    } else echo json_encode(['status'=>'error', 'msg'=>'Lagu tidak ditemukan']);
    exit;
}

if ($action === 'upload_subtitle_file') {
    $id = (int)$_POST['id'];
    if ($id <= 0 || !isset($_FILES['subfile'])) { echo json_encode(['status'=>'error', 'msg'=>'File tidak dipilih']); exit; }
    $q = mysqli_query($conn, "SELECT filepath FROM songs WHERE id = $id");
    if ($row = mysqli_fetch_assoc($q)) {
        $base_folder = rtrim($SOURCE_FOLDER, '/\\') . DIRECTORY_SEPARATOR;
        $mp4_path = $base_folder . $row['filepath'];
        $target_path = preg_replace('/\.[^.]+$/', '.vtt', $mp4_path);
        if(move_uploaded_file($_FILES['subfile']['tmp_name'], $target_path)) echo json_encode(['status'=>'success']);
        else echo json_encode(['status'=>'error', 'msg'=>'Gagal simpan file']);
    } else echo json_encode(['status'=>'error', 'msg'=>'Lagu tidak ditemukan']);
    exit;
}

// --- 11 & 12. REMOTE & YOUTUBE PROXY ---
if ($action === 'remote_send') {
    $cmd = mysqli_real_escape_string($conn, $_POST['cmd']);
    $val = mysqli_real_escape_string($conn, $_POST['val'] ?? '');
    $sql = "INSERT INTO remote_commands (command, payload) VALUES ('$cmd', '$val')";
    if(mysqli_query($conn, $sql)) echo json_encode(['status'=>'success']);
    else echo json_encode(['status'=>'error']);
    exit;
}

if ($action === 'remote_poll') {
    $q = mysqli_query($conn, "SELECT * FROM remote_commands WHERE status='pending' ORDER BY created_at ASC LIMIT 1");
    if ($row = mysqli_fetch_assoc($q)) {
        mysqli_query($conn, "UPDATE remote_commands SET status='executed' WHERE id=".$row['id']);
        echo json_encode(['status' => 'command', 'cmd' => $row['command'], 'val' => $row['payload']]);
    } else echo json_encode(['status' => 'idle']);
    exit;
}

if ($action === 'get_local_ip') {
    $ip = getHostByName(getHostName());
    echo json_encode(['ip' => $ip]);
    exit;
}

if ($action === 'remote_yt_search') {
    $q = urlencode($_POST['query']);
    $dq = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'yt_api_key'");
    $row = mysqli_fetch_assoc($dq);
    $apiKey = $row['setting_value'] ?? '';
    if(empty($apiKey)) { echo json_encode(['error' => 'API Key Kosong']); exit; }
    $url = "https://www.googleapis.com/youtube/v3/search?part=snippet&maxResults=20&q={$q}+karaoke&type=video&key={$apiKey}";
    $response = @file_get_contents($url);
    if($response === FALSE) echo json_encode(['error' => 'Gagal menghubungi YouTube']);
    else echo $response; 
    exit;
}

// --- 13. MANAJEMEN PLAYLIST ---
if ($action === 'delete_playlist') {
    $id = (int)$_POST['id'];
    mysqli_query($conn, "DELETE FROM playlists WHERE id=$id");
    echo json_encode(['status'=>'success']);
    exit;
}

if ($action === 'rename_playlist') {
    $id = (int)$_POST['id'];
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    mysqli_query($conn, "UPDATE playlists SET name='$name' WHERE id=$id");
    echo json_encode(['status'=>'success']);
    exit;
}

if ($action === 'update_playlist') {
    $id = (int)$_POST['id'];
    $items = json_decode($_POST['songs'], true);
    if($id <= 0) { echo json_encode(['status'=>'error']); exit; }
    mysqli_query($conn, "DELETE FROM playlist_items WHERE playlist_id=$id");
    foreach ($items as $idx => $item) {
        $songId = 0;
        if (is_array($item) && isset($item['videoId'])) {
            $title = mysqli_real_escape_string($conn, $item['title']);
            $vid = mysqli_real_escape_string($conn, $item['videoId']);
            $check = mysqli_query($conn, "SELECT id FROM songs WHERE filepath = '$vid' AND filetype='youtube' LIMIT 1");
            if ($row = mysqli_fetch_assoc($check)) $songId = $row['id'];
            else {
                mysqli_query($conn, "INSERT INTO songs (title, filepath, filetype) VALUES ('$title', '$vid', 'youtube')");
                $songId = mysqli_insert_id($conn);
            }
        } else {
            $titleStr = is_array($item) ? $item['title'] : $item;
            $safeTitle = mysqli_real_escape_string($conn, $titleStr);
            $qSong = mysqli_query($conn, "SELECT id FROM songs WHERE title = '$safeTitle' AND filetype != 'youtube' LIMIT 1");
            if($row = mysqli_fetch_assoc($qSong)) $songId = $row['id'];
        }
        if ($songId > 0) mysqli_query($conn, "INSERT INTO playlist_items (playlist_id, song_id, sort_order) VALUES ($id, $songId, $idx)");
    }
    echo json_encode(['status' => 'success']);
    exit;
}


// ==========================================
// BAGIAN 2: FITUR BARU (BILLING & TIMER)
// ==========================================

// --- 14. SETTING HARGA ---
if ($action === 'save_rate') {
    $rate = (int)$_POST['rate'];
    $val = (string)$rate;
    mysqli_query($conn, "INSERT INTO settings (setting_key, setting_value) VALUES ('hourly_rate', '$val') 
                         ON DUPLICATE KEY UPDATE setting_value = '$val'");
    echo json_encode(['status'=>'success']);
    exit;
}

// --- 15. SETTING RUNNING TEXT ---
if ($action === 'save_running_text') {
    $text = mysqli_real_escape_string($conn, $_POST['text']);
    mysqli_query($conn, "INSERT INTO settings (setting_key, setting_value) VALUES ('running_text', '$text') 
                         ON DUPLICATE KEY UPDATE setting_value = '$text'");
    echo json_encode(['status'=>'success']);
    exit;
}

// --- 16. INFO PLAYER (GABUNGAN TIMER & TEXT) ---
if ($action === 'get_player_info') {
    // Ambil Running Text
    $qText = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'running_text'");
    $rText = mysqli_fetch_assoc($qText);
    $text = $rText['setting_value'] ?? '';

    // Ambil Timer
    $qTime = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'billing_expiry'");
    $rTime = mysqli_fetch_assoc($qTime);
    $expiry = (int)($rTime['setting_value'] ?? 0);
    $remaining = $expiry - time();

    // Pastikan jika expired, remaining tidak negatif
    if ($remaining < 0) $remaining = 0;

    echo json_encode([
        'running_text' => $text,
        'timer_status' => ($remaining <= 0) ? 'expired' : 'active',
        'remaining' => $remaining
    ]);
    exit;
}

// --- 17. LAPORAN KEUANGAN ---
if ($action === 'get_revenue_report') {
    $today = date('Y-m-d');
    $q = mysqli_query($conn, "SELECT * FROM billing_logs WHERE DATE(timestamp) = '$today' ORDER BY id DESC");
    
    $logs = [];
    $total = 0;
    while($row = mysqli_fetch_assoc($q)) {
        $logs[] = $row;
        $total += $row['amount'];
    }
    
    $qRate = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'hourly_rate'");
    $rRate = mysqli_fetch_assoc($qRate);
    $currentRate = $rRate['setting_value'] ?? 0;

    echo json_encode(['logs'=>$logs, 'total'=>$total, 'rate'=>$currentRate]);
    exit;
}

// --- 18. LOGIKA TIMER PUSAT (REMOTE & LOCAL) ---
// Menangani set_timer, add_timer, dan secure_timer_remote
if ($action === 'set_timer' || $action === 'add_timer' || $action === 'secure_timer_remote') {
    
    $mode = '';
    $minutes = (int)($_POST['minutes'] ?? 0);
    
    // Validasi Password jika akses dari Remote
    if ($action === 'secure_timer_remote') {
        $passInput = $_POST['password'] ?? '';
        $mode = $_POST['mode']; // set, add, stop

        $checkPass = mysqli_query($conn, "SELECT id FROM users WHERE password = '$passInput' LIMIT 1");
        if (mysqli_num_rows($checkPass) == 0) {
            echo json_encode(['status'=>'error', 'msg'=>'Password Admin Salah!']);
            exit;
        }
    } else {
        // Akses dari Local (settings.php), tidak butuh password tapi butuh penentuan mode
        if ($action === 'set_timer') {
            $mode = ($minutes == 0) ? 'stop' : 'set';
        } elseif ($action === 'add_timer') {
            $mode = 'add';
        }
    }

    // --- LOGIKA HITUNG DUIT & WAKTU ---
    
    // 1. Ambil Tarif Per Jam
    $qRate = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'hourly_rate'");
    $rRate = mysqli_fetch_assoc($qRate);
    $rate = (int)($rRate['setting_value'] ?? 0);

    // 2. Hitung Rupiah
    $amount = ($minutes / 60) * $rate;

    // 3. Proses Waktu
    $qExp = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'billing_expiry'");
    $rExp = mysqli_fetch_assoc($qExp);
    $currentExpiry = (int)($rExp['setting_value'] ?? 0);
    $now = time();
    $newExpiry = 0;
    $msg = "Sukses";

    if ($mode === 'set') {
        $newExpiry = $now + ($minutes * 60);
        // Log Transaksi Baru
        if($minutes > 0) {
            mysqli_query($conn, "INSERT INTO billing_logs (minutes, amount, note) VALUES ($minutes, $amount, 'Sewa Baru')");
        }
        $msg = "Timer diset $minutes menit";
    } 
    elseif ($mode === 'add') {
        if ($currentExpiry < $now) {
            $newExpiry = $now + ($minutes * 60);
        } else {
            $newExpiry = $currentExpiry + ($minutes * 60);
        }
        // Log Transaksi Tambahan
        if($minutes > 0) {
            mysqli_query($conn, "INSERT INTO billing_logs (minutes, amount, note) VALUES ($minutes, $amount, 'Tambah Waktu')");
        }
        $msg = "Waktu ditambah $minutes menit";
    } 
    elseif ($mode === 'stop') {
        $newExpiry = 0; 
        $msg = "Sesi dihentikan";
    }

    // Simpan Waktu Baru
    $val = (string)$newExpiry;
    mysqli_query($conn, "INSERT INTO settings (setting_key, setting_value) VALUES ('billing_expiry', '$val') 
                         ON DUPLICATE KEY UPDATE setting_value = '$val'");

    echo json_encode(['status'=>'success', 'msg'=>$msg]);
    exit;
}

// Cek status timer lama (Legacy support jika ada script lama yang memanggil ini)
if ($action === 'check_timer_status') {
    $q = mysqli_query($conn, "SELECT setting_value FROM settings WHERE setting_key = 'billing_expiry'");
    $row = mysqli_fetch_assoc($q);
    $expiry = (int)($row['setting_value'] ?? 0);
    $remaining = $expiry - time();
    if ($remaining <= 0) echo json_encode(['status' => 'expired', 'remaining' => 0]);
    else echo json_encode(['status' => 'active', 'remaining' => $remaining]);
    exit;
}

?>