<?php
session_start();
if (!isset($_SESSION['user'])) {
    if(isset($_COOKIE['k_user'])) { $_SESSION['user'] = $_COOKIE['k_user']; } 
    else { header("Location: login.php"); exit; }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <meta charset="UTF-8">
    <title>EZIDCODE KARAOKE</title>
    <style>
    
    
    /* --- CINEMA MODE (FAKE FULLSCREEN) --- */
body.cinema-active .top-area { height: 100vh !important; border-bottom: none; }
body.cinema-active .workspace { display: none !important; } /* Sembunyikan playlist */
body.cinema-active #audioVis { opacity: 0.5; } /* Visualizer tetap ada tapi transparan */
    
        body { background: #121212; color: #ddd; font-family: 'Segoe UI', sans-serif; display: flex; flex-direction: column; height: 100vh; margin:0; overflow:hidden; }
        
        /* PLAYER */
        .top-area { height: 45vh; background: black; position: relative; border-bottom: 2px solid #d4af37; }
        video { width: 100%; height: 100%; outline: none; }
        #overlayTitle { position:absolute; top:10px; left:15px; font-weight:bold; font-size:18px; text-shadow:2px 2px 4px black; color: white; pointer-events: none; }

        /* WORKSPACE */
        .workspace { flex: 1; display: flex; overflow: hidden; }
        .col { flex: 1; padding: 10px; border-right: 1px solid #333; display: flex; flex-direction: column; min-width: 0; }
        
        h3 { margin: 0 0 10px 0; color: #d4af37; font-size: 14px; text-transform: uppercase; border-bottom: 1px solid #444; padding-bottom: 5px; }
        
        .list-box { flex: 1; overflow-y: auto; background: #1a1a1a; border: 1px solid #333; }
        .item { padding: 8px; border-bottom: 1px solid #2a2a2a; cursor: pointer; display: flex; justify-content: space-between; align-items: center; font-size: 13px; }
        .item:hover { background: #333; }
        .item.active { background: #333; border-left: 3px solid #d4af37; color: #d4af37; font-weight: bold; }
        
        /* BUTTONS */
        .btn { border: none; padding: 8px; cursor: pointer; border-radius: 4px; color: white; font-weight: bold; font-size: 11px; margin-bottom: 5px; width: 100%; }
        .btn-green { background: #2e7d32; } .btn-green:hover { background: #1b5e20; }
        .btn-blue { background: #1565c0; } .btn-blue:hover { background: #0d47a1; }
        .btn-red { background: #c62828; }
        .btn-gold { background: #fbc02d; color: black; }
        .btn-grey { background: #444; color: #ccc; }

        /* FOLDER TAGS */
        .folder-tag { display: flex; justify-content: space-between; background: #222; padding: 5px; margin-bottom: 2px; font-size: 11px; border-left: 2px solid #555; }
        .folder-tag.active { border-left: 2px solid #2e7d32; background: #1e3a20; }
        
        .badge { padding: 2px 6px; border-radius: 4px; font-size: 10px; }
        .ok { background: #2e7d32; color: white; }
        .err { background: #c62828; color: white; }
        
        
        
        /* --- VISUALIZER --- */
        #audioVis { 
            position: absolute; bottom: 0; left: 0; 
            width: 100%; height: 120px; 
            z-index: 20; /* Pastikan di atas video */
            pointer-events: none; opacity: 0.9; 
        }

        /* --- SIDEBAR HIDDEN (SAMA SEKALI TIDAK TERLIHAT) --- */
        .audio-sidebar { 
            position: fixed; top: 0; 
            right: -350px; /* Disembunyikan sepenuhnya */
            width: 300px; height: 100%; 
            background: #111; 
            border-left: 2px solid #d4af37; 
            z-index: 200; 
            padding: 20px; 
            transition: 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); 
            box-shadow: -10px 0 30px rgba(0,0,0,0.9);
            display: flex; flex-direction: column;
        }
        
        .audio-sidebar.open { right: 0; } /* Muncul saat class 'open' aktif */

       /* --- SLIDER HORIZONTAL BARU (BIRU) --- */
        .slider-group { margin-bottom: 12px; }
        
        .slider-info { 
            display: flex; justify-content: space-between; 
            font-size: 11px; color: #ddd; font-weight: bold; margin-bottom: 2px;
        }
        
        /* Gaya Slider Biru */
        input[type=range].horiz-slider {
            -webkit-appearance: none; appearance: none;
            width: 100%; height: 6px;
            background: #333; border: 1px solid #555; border-radius: 3px; outline: none;
            cursor: pointer; display: block; margin: 5px 0;
        }
        
        input[type=range].horiz-slider::-webkit-slider-thumb {
            -webkit-appearance: none; appearance: none;
            width: 16px; height: 16px; border-radius: 50%; 
            background: #2196f3; /* WARNA BIRU */
            border: 2px solid #fff;
            box-shadow: 0 0 8px rgba(33, 150, 243, 0.6);
        }

        /* Ruler / Angka Mistar di Bawah Slider */
        .slider-ruler { 
            display: flex; justify-content: space-between; 
            font-size: 9px; color: #666; font-family: monospace;
        }

        .band-val { font-size: 9px; color: #d4af37; font-weight: bold; margin-bottom: 5px; min-height:12px;}
        .band-freq { font-size: 8px; color: #888; position: absolute; bottom: 5px; transform: rotate(-45deg); }
        .band-num { position:absolute; top: -5px; font-size: 9px; color:#555; font-weight:bold; border:1px solid #333; padding:1px 3px; border-radius:3px; }
        
        /* Subtitle Area */
        #subtitleDisplay {
            position: absolute; bottom: 60px; width: 100%; text-align: center;
            color: white; font-size: 24px; font-weight: bold; 
            text-shadow: 2px 2px 4px black, 0 0 5px blue;
            pointer-events: none; z-index: 50; padding: 0 20px;
            white-space: pre-wrap;
        }
        
        
        
    </style>
</head>
<body>
    
    <div id="marqueeContainer" style="display:none; position:fixed; top:0; left:0; width:100%; background:rgba(0,0,0,0.8); color:#d4af37; z-index:99990; font-weight:bold; font-size:24px; padding:10px 0; border-bottom:2px solid gold; overflow:hidden; white-space:nowrap; pointer-events:none;">
    <div id="marqueeText" style="display:inline-block; padding-left:100%; animation: scroll-text 15s linear infinite;">
        Selamat Datang di Karaoke Kami!
    </div>
</div>

<style>
@keyframes scroll-text {
    0% { transform: translateX(0); }
    100% { transform: translateX(-100%); }
}
body.cinema-active #marqueeContainer { display: block !important; } 
</style>
    
    <div id="qrPopup" style="display:none; position:fixed; top:20%; left:50%; transform:translate(-50%, -20%); background:white; padding:20px; z-index:9999; border-radius:10px; text-align:center; color:black; box-shadow:0 0 50px rgba(0,0,0,0.8);">
    <h3 style="margin-top:0; color:black;">SCAN UNTUK REMOTE</h3>
    <div id="qrcode" style="margin:10px auto;"></div>
    <div id="ipLink" style="font-size:12px; margin-top:5px; font-weight:bold;"></div>
    <button onclick="document.getElementById('qrPopup').style.display='none'" style="margin-top:10px; background:#333; color:white; border:none; padding:5px 15px; cursor:pointer;">TUTUP</button>
</div>

<button onclick="showRemoteQR()" style="position:fixed; bottom:20px; right:20px; z-index:1000; background:#d4af37; border:none; padding:10px; border-radius:50%; width:50px; height:50px; font-weight:bold; cursor:pointer; box-shadow:0 0 10px gold;">📱</button>
    

    <div class="top-area">
        <video id="player" controls crossorigin="anonymous"></video>
        
        <canvas id="audioVis"></canvas>
        
        <div id="overlayTitle">EZIDCODE KARAOKE</div>
        
        
        
        
        
        
        
        
        <div style="position:absolute; top:10px; right:15px; z-index:100;">
            <button onclick="toggleSidebar()" style="background:#1565c0; color:white; border:none; padding:8px 15px; border-radius:4px; font-weight:bold; cursor:pointer; margin-right:5px;">🎚 AUDIO FX</button>
            <button onclick="location.href='youtube.php'" style="background:red; color:white; border:none; padding:8px 15px; border-radius:4px; font-weight:bold; cursor:pointer; margin-right:5px;">📺 YOUTUBE MODE</button>
            <button onclick="location.href='settings.php'" style="background:#444; color:white; border:none; padding:8px 15px; border-radius:4px; font-weight:bold; cursor:pointer;">⚙️ PENGATURAN</button>
        </div>
    </div>

    <div class="workspace">
        
        <div class="col">
            <h3>1. Folder Manager</h3>
            
            <div id="folderControls">
                <button class="btn btn-green" onclick="addFolder()">➕ TAMBAH FOLDER BARU</button>
                <button class="btn btn-gold" id="btnReconnect" style="display:none" onclick="reconnectAll()">🔄 RECONNECT SEMUA (REFRESH)</button>
            </div>

            <div style="font-size:11px; color:#aaa; margin-bottom:5px;">Daftar Folder Terhubung:</div>
            <div id="folderList" style="max-height: 150px; overflow-y:auto; margin-bottom:10px; border:1px solid #333;"></div>
            
            <button class="btn btn-red" onclick="resetFolders()" style="margin-top:5px;">⚠️ RESET SEMUA KONEKSI</button>
        </div>

        <div class="col">
            <h3>2. Library Lagu</h3>
            <input type="text" id="search" placeholder="Cari Judul..." oninput="renderLibrary()" style="width:100%; box-sizing:border-box; padding:5px; margin-bottom:5px;">
            <div id="libStatus" style="font-size:10px; color:#aaa; text-align:right;">0 Lagu</div>
            <div class="list-box" id="libList"></div>
        </div>

        <div class="col">
            <h3>3. Antrian / Playlist</h3>
            <div style="display:flex; gap:5px;">
                <button class="btn btn-blue" onclick="savePlaylist()">💾 SIMPAN</button>
                <button class="btn btn-gold" onclick="loadPlaylistList()">📂 LOAD</button>
                <button class="btn btn-red" onclick="clearQueue()" style="width:30px">×</button>
            </div>
            
            <div id="savedPlaylistsArea" style="display:none; background:#222; padding:5px; margin-bottom:5px; border:1px solid gold;">
                <div style="font-size:10px; color:gold; margin-bottom:3px;">PILIH PLAYLIST: <span style="float:right; cursor:pointer;" onclick="this.parentElement.style.display='none'">[Tutup]</span></div>
                <div id="savedList" style="max-height:100px; overflow-y:auto;"></div>
            </div>

            <div class="list-box" id="queueList"></div>
        </div>

    </div>
    
    
    
    <div id="audioSidebar" class="audio-sidebar">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:10px;">
            <h3 style="margin:0; font-size:16px;">🎚 AUDIO & SUBTITLE</h3>
            <button onclick="toggleSidebar()" style="background:none; border:none; color:white; font-size:20px; cursor:pointer;">&times;</button>
        </div>

        <div class="fx-group">
            <span class="fx-label">📝 SUBTITLE / LIRIK</span>
            
            <div style="margin-bottom:10px;">
                <button class="btn-fx" id="btnAutoSub" onclick="toggleLiveCaption()" style="width:100%; margin-bottom:5px;">
                    🎙️ BUAT SUBTITLE (AI RECORD)
                </button>
                <div style="font-size:9px; color:#aaa; line-height:1.2;">
                    *Khusus PC/Laptop dengan "Stereo Mix" aktif. Di HP audio akan mati jika Mic nyala.
                </div>
            </div>

            <div style="border-top:1px dashed #444; padding-top:10px;">
                <span class="fx-label" style="font-size:10px; color:#888;">UPLOAD FILE MANUAL (.SRT / .VTT)</span>
                <div style="display:flex; gap:5px;">
                    <input type="file" id="subUpload" accept=".srt,.vtt" style="font-size:10px; color:#aaa; width:100%">
                    <button class="btn-blue" onclick="uploadSubtitleFile()" style="width:auto; padding:5px 10px;">⬆</button>
                </div>
            </div>
        </div>

        
        
        
        <div class="fx-group">
            <span class="fx-label">5-BAND CONTROL PRO</span>
            
            <div id="eqContainer" style="padding: 5px 0;">
                
                <div class="slider-group">
                    <div class="slider-info"><span>BASS</span> <span id="val-bass" style="color:#2196f3">0dB</span></div>
                    <input type="range" class="horiz-slider" min="-15" max="15" value="0" step="1" oninput="updateTone('bass', this.value)">
                    <div class="slider-ruler"><span>-15</span><span>0</span><span>+15</span></div>
                </div>

                <div class="slider-group">
                    <div class="slider-info"><span>VOKAL</span> <span id="val-mid" style="color:#2196f3">0dB</span></div>
                    <input type="range" class="horiz-slider" min="-15" max="15" value="0" step="1" oninput="updateTone('mid', this.value)">
                    <div class="slider-ruler"><span>-15</span><span>0</span><span>+15</span></div>
                </div>

                <div class="slider-group">
                    <div class="slider-info"><span>PRESENCE</span> <span id="val-presence" style="color:#2196f3">0dB</span></div>
                    <input type="range" class="horiz-slider" min="-15" max="15" value="0" step="1" oninput="updateTone('presence', this.value)">
                    <div class="slider-ruler"><span>-15</span><span>0</span><span>+15</span></div>
                </div>

                <div class="slider-group">
                    <div class="slider-info"><span>TREBLE</span> <span id="val-treble" style="color:#2196f3">0dB</span></div>
                    <input type="range" class="horiz-slider" min="-15" max="15" value="0" step="1" oninput="updateTone('treble', this.value)">
                    <div class="slider-ruler"><span>-15</span><span>0</span><span>+15</span></div>
                </div>

                <div class="slider-group">
                    <div class="slider-info"><span>VOLUME</span> <span id="val-gain" style="color:#2196f3">100%</span></div>
                    <input type="range" class="horiz-slider" min="0" max="200" value="100" step="5" oninput="updateTone('gain', this.value)">
                    <div class="slider-ruler"><span>0%</span><span>100%</span><span>200%</span></div>
                </div>

            </div>
            
            <button class="btn btn-grey" onclick="resetTone()">RESET FLAT</button>
        </div>
        
        
        

        <div class="fx-group">
            <span class="fx-label">VOICE FX</span>
            <div class="fx-btn-grid">
                <button class="btn-fx" onclick="setVoice('normal')">Normal</button>
                <button class="btn-fx" onclick="setVoice('chipmunk')">Anak-Anak</button>
                <button class="btn-fx" onclick="setVoice('man')">Pria Berat</button>
                <button class="btn-fx" onclick="setVoice('monster')">Monster</button>
            </div>
        </div>
    </div>
    
    

    <script>
        // --- GLOBAL VARIABLES ---
        let folderRegistry = {};  // Menyimpan { "NamaFolder": HandleObject }
        let fileCache = {};       // Menyimpan { "JudulLagu.mp4": FileHandle }
        let library = [];         
        let queue = [];
        let currentLoadedPlId = null;
        let currentIndex = -1;

        // --- INIT ---
        window.onload = async function() {
            // 1. Load Data
            await refreshLibrary();
            
            // 2. Load Folder Handles dari IndexedDB
            const savedHandles = await getAllHandlesDB();
            
            if (savedHandles.length > 0) {
                // Restore ke memori
                savedHandles.forEach(h => { folderRegistry[h.name] = h; });
                renderFolderList(true); // Tampilkan list folder (status: butuh reconnect)
                document.getElementById('btnReconnect').style.display = 'block';
                alert("Selamat datang kembali! Silakan klik tombol kuning 'RECONNECT SEMUA' untuk mengaktifkan akses ke " + savedHandles.length + " folder Anda.");
            }

            // 3. Load Queue Terakhir
            const lastQ = localStorage.getItem('k_queue');
            if(lastQ) { queue = JSON.parse(lastQ); renderQueue(); }
        };

        // --- A. MULTI-FOLDER SYSTEM ---
        
        // 1. Tambah Folder Baru
        async function addFolder() {
            if (!window.showDirectoryPicker) return alert("Browser tidak support.");
            try {
                const newHandle = await window.showDirectoryPicker();
                
                // Simpan ke Registry & DB
                folderRegistry[newHandle.name] = newHandle;
                await saveHandleDB(newHandle);
                
                // Scan folder ini saja
                await scanSpecificFolder(newHandle);
                
                renderFolderList();
                document.getElementById('btnReconnect').style.display = 'block';
            } catch (err) { 
                if (err.name !== 'AbortError') alert("Error: " + err.message);
            }
        }

        // 2. Reconnect Semua (Saat Refresh)
        async function reconnectAll() {
            let successCount = 0;
            const folders = Object.values(folderRegistry);
            
            for (const handle of folders) {
                // Cek Izin
                let hasPerm = (await handle.queryPermission({mode:'read'})) === 'granted';
                if (!hasPerm) {
                    // Request izin (Browser akan popup)
                    if ((await handle.requestPermission({mode:'read'})) === 'granted') {
                        hasPerm = true;
                    }
                }
                
                if (hasPerm) {
                    await scanSpecificFolder(handle); // Scan ulang isinya
                    successCount++;
                }
            }
            
            if(successCount > 0) alert(`${successCount} Folder berhasil terhubung kembali!`);
            renderFolderList();
            renderQueue(); // Update status lampu hijau
        }

        // 3. Scan Isi Folder (Rekursif)
        async function scanSpecificFolder(handle) {
            // Update UI Folder jadi hijau
            const tag = document.getElementById(`folder-${handle.name}`);
            if(tag) { tag.className = 'folder-tag active'; tag.innerHTML = `📂 ${handle.name} <span style="color:#8f8">Scanning...</span>`; }

            let scannedNames = [];
            
            // Fungsi baca subfolder
            async function traverse(dir) {
                for await (const entry of dir.values()) {
                    if (entry.kind === 'file') {
                        if (entry.name.match(/\.(mp4|mkv|webm|mp3|avi|mpg)$/i)) {
                            fileCache[entry.name] = entry; // Masukkan ke Global Cache
                            scannedNames.push(entry.name);
                        }
                    } else if (entry.kind === 'directory') {
                        await traverse(entry);
                    }
                }
            }

            await traverse(handle);
            
            // Update UI selesai
            if(tag) { tag.innerHTML = `📂 ${handle.name} <span style="color:#fff">✅ ${scannedNames.length} file</span>`; }

            // Sync ke DB
            if(scannedNames.length > 0) syncFilesToDB(scannedNames);
        }

        function renderFolderList(needAuth = false) {
            const div = document.getElementById('folderList');
            div.innerHTML = '';
            
            Object.values(folderRegistry).forEach(h => {
                const el = document.createElement('div');
                el.id = `folder-${h.name}`;
                // Jika needAuth=true, warnanya default (abu), jika tidak berarti sudah aktif (hijau nanti diatur scan)
                el.className = 'folder-tag'; 
                el.innerHTML = `📂 ${h.name} <span style="color:${needAuth?'#f88':'#aaa'}">${needAuth?'⚠ Butuh Reconnect':'Menunggu...'}</span>`;
                div.appendChild(el);
            });
            
            if (Object.keys(folderRegistry).length === 0) div.innerHTML = '<div style="padding:5px; color:#555; text-align:center;">Belum ada folder.</div>';
        }

        async function resetFolders() {
            if(confirm("Hapus semua daftar folder yang tersimpan? (Anda harus add ulang)")) {
                await clearDB();
                folderRegistry = {};
                fileCache = {};
                renderFolderList();
                location.reload();
            }
        }

        // --- B. DATABASE SYNC ---
        function syncFilesToDB(names) {
            const fd = new FormData();
            fd.append('action', 'sync_files');
            fd.append('files', JSON.stringify(names));
            fetch('api.php', { method: 'POST', body: fd })
            .then(r => r.json())
            .then(() => refreshLibrary());
        }

        async function refreshLibrary() {
            const r = await fetch('api.php?action=get_all_songs');
            library = await r.json();
            document.getElementById('libStatus').innerText = library.length + " Lagu di Database";
            renderLibrary();
        }

        // --- UPDATE 1: SAVE LOCAL ---
function savePlaylist() {
    if (queue.length === 0) return alert("Antrian kosong!");

    let actionName = 'save_playlist';
    let plName = '';
    let plId = 0;

    // Cek apakah kita sedang mengedit playlist lama?
    if (currentLoadedPlId) {
        if (confirm("UPDATE Playlist yang sedang aktif ini?\nKlik OK untuk Update.\nKlik Cancel untuk Simpan sebagai BARU.")) {
            actionName = 'update_playlist';
            plId = currentLoadedPlId;
        } else {
            // User pilih Cancel -> Simpan Baru
            plName = prompt("Nama Playlist BARU:");
            if (!plName) return;
            currentLoadedPlId = null; // Reset karena jadi baru
        }
    } else {
        // Memang baru
        plName = prompt("Nama Playlist LOKAL:");
        if (!plName) return;
    }

    const titles = queue.map(item => item.title);

    const fd = new FormData();
    fd.append('action', actionName);
    if (actionName === 'save_playlist') fd.append('name', plName);
    if (actionName === 'update_playlist') fd.append('id', plId);
    fd.append('type', 'local');
    fd.append('songs', JSON.stringify(titles));

    fetch('api.php', { method: 'POST', body: fd }).then(r=>r.json()).then(d=>{
        if(d.status === 'success') alert("Playlist Berhasil Disimpan/Diupdate!");
        else alert("Gagal: " + d.msg);
    });
}

// --- UPDATE 2: LOAD LOCAL ---
function loadPlaylistList() {
    const area = document.getElementById('savedPlaylistsArea');
    area.style.display = 'block';
    
    // Filter hanya ambil yang type=local
    fetch('api.php?action=get_playlists&type=local').then(r=>r.json()).then(data => {
        const div = document.getElementById('savedList');
        div.innerHTML = '';
        if(data.length === 0) div.innerHTML = '<div style="color:#777">Tidak ada playlist lokal.</div>';
        
        data.forEach(p => {
            const el = document.createElement('div');
            el.style.padding = "3px"; el.style.cursor="pointer"; el.style.borderBottom="1px solid #333";
            el.innerHTML = `💿 ${p.name}`;
            el.onclick = () => {
                if(confirm("Load playlist ini?")) {
                    fetch('api.php?action=load_playlist_items&id=' + p.id).then(r=>r.json()).then(titles => {
                        currentLoadedPlId = p.id;
                        // Handle format baru API yang return object {title, videoId, type}
                        // Untuk index.php kita cuma butuh title
                        queue = titles.map(t => ({ title: t.title })); 
                        saveQueueLocal();
                        renderQueue();
                        area.style.display = 'none';
                    });
                }
            };
            div.appendChild(el);
        });
    });
}




        // --- D. PLAYER CORE ---
        // --- UPDATED: RENDER LIBRARY (Hanya tampilkan yang BELUM ada di queue) ---
        function renderLibrary() {
            const q = document.getElementById('search').value.toLowerCase();
            const div = document.getElementById('libList');
            div.innerHTML = '';
            
            // Filter: Judul cocok dgn pencarian DAN Judul TIDAK ada di queue
            const filtered = library.filter(s => 
                s.title.toLowerCase().includes(q) && 
                !queue.some(queuedItem => queuedItem.title === s.title) // Cek duplikat
            );
            
            // Tombol Tambah Semua (Hanya muncul jika ada hasil)
            if(filtered.length > 0) {
                const addAllBtn = document.createElement('div');
                addAllBtn.style.padding = "10px";
                addAllBtn.style.textAlign = "center";
                addAllBtn.style.borderBottom = "1px solid #444";
                addAllBtn.innerHTML = `<button class="btn btn-green" onclick="addAllDisplayedToQueue()">➕ TAMBAHKAN SEMUA (${filtered.length}) KE PLAYLIST</button>`;
                div.appendChild(addAllBtn);
            }

            filtered.slice(0,100).forEach(s => {
                const el = document.createElement('div');
                el.className = 'item';
                el.innerHTML = `<span>${s.title}</span> <button class="btn-green" style="width:auto; padding:2px 8px;">+</button>`;
                el.onclick = (e) => addToQueue(s.title);
                div.appendChild(el);
            });
            
            document.getElementById('libStatus').innerText = filtered.length + " Lagu Tersedia (Sisa)";
        }

        // --- UPDATED: ADD TO QUEUE (Cek Duplikat & Refresh Library) ---
        function addToQueue(title) {
            // Cek Duplikat Double Protection
            if(queue.some(item => item.title === title)) {
                alert("Lagu ini sudah ada di playlist!");
                return;
            }

            queue.push({ title: title });
            saveQueueLocal();
            renderQueue();
            
            // Render ulang library agar lagu yang baru ditambah HILANG dari daftar
            renderLibrary(); 
        }
        
        
        // --- BARU: TAMBAH SEMUA KE QUEUE ---
        function addAllDisplayedToQueue() {
            const q = document.getElementById('search').value.toLowerCase();
            // Ambil semua yang lolos filter saat ini
            const toAdd = library.filter(s => 
                s.title.toLowerCase().includes(q) && 
                !queue.some(queuedItem => queuedItem.title === s.title)
            );
            
            if(toAdd.length === 0) return;
            if(!confirm(`Tambahkan ${toAdd.length} lagu sekaligus?`)) return;

            toAdd.forEach(s => {
                queue.push({ title: s.title });
            });
            
            saveQueueLocal();
            renderQueue();
            renderLibrary(); // Library akan langsung kosong/berkurang
        }

        function renderQueue() {
            const div = document.getElementById('queueList');
            div.innerHTML = '';
            queue.forEach((item, idx) => {
                const el = document.createElement('div');
                el.className = 'item ' + (idx === currentIndex ? 'active' : '');
                
                // Cek Cache Global
                const isReady = fileCache[item.title]; 
                const statusHtml = isReady ? `<span class="badge ok">READY</span>` : `<span class="badge err">MISSING</span>`;
                
                el.innerHTML = `
                    <div style="flex:1; overflow:hidden;">
                        <div style="font-weight:bold; white-space:nowrap;">${idx+1}. ${item.title}</div>
                        <div>${statusHtml}</div>
                    </div>
                    <button style="background:none; color:red; border:none; font-size:16px;" onclick="removeFromQueue(${idx})">×</button>
                `;
                el.onclick = (e) => { if(e.target.tagName !== 'BUTTON') play(idx); };
                div.appendChild(el);
            });
        }

        async function play(idx) {
            if(idx >= queue.length) idx = 0; if(idx < 0) return;
            const item = queue[idx];
            
            // Cari handle file
            const handle = fileCache[item.title];
            if (!handle) {
                alert(`File "${item.title}" belum terbaca. Reconnect folder dulu.`); 
                return;
            }

            currentIndex = idx; renderQueue();
            document.getElementById('overlayTitle').innerText = item.title;
            
            // --- [TAMBAHAN] Init Audio & Subtitle ---
            if(typeof initAudioContext === 'function') {
                if(!isAudioInit) initAudioContext();
                if(audioCtx && audioCtx.state === 'suspended') audioCtx.resume();
                
                // Cari ID lagu untuk ambil subtitle
                const songObj = library.find(s => s.title === item.title);
                if(songObj && typeof checkSubtitle === 'function') {
                    checkSubtitle(songObj.id);
                }
            }
            // ----------------------------------------
            
            try {
                const file = await handle.getFile();
                const url = URL.createObjectURL(file);
                const player = document.getElementById('player');
                player.src = url; 
                player.play();
            } catch(e) {
                alert("Gagal memutar: " + e.message);
            }
        }

        document.getElementById('player').onended = () => play(currentIndex + 1);
        function removeFromQueue(i) { queue.splice(i,1); saveQueueLocal(); renderQueue(); }
        
        function clearQueue() { 
    queue=[]; 
    currentLoadedPlId = null; // Reset ID saat dihapus
    saveQueueLocal(); 
    renderQueue(); 
    renderLibrary(); // Kembalikan semua lagu ke library
}
        
        
        function saveQueueLocal() { localStorage.setItem('k_queue', JSON.stringify(queue)); }

        // --- E. INDEXED DB (MULTI STORAGE) ---
        const DB_NAME = 'KaraokeMultiDB';
        const STORE_NAME = 'handles';

        function openDB() {
            return new Promise((res, rej) => {
                const r = indexedDB.open(DB_NAME, 1);
                r.onupgradeneeded = e => { 
                    if(!e.target.result.objectStoreNames.contains(STORE_NAME)) 
                        e.target.result.createObjectStore(STORE_NAME); 
                };
                r.onsuccess = e => res(e.target.result);
                r.onerror = e => rej(e);
            });
        }
        
        async function saveHandleDB(handle) {
            const db = await openDB();
            const tx = db.transaction(STORE_NAME, 'readwrite');
            // Gunakan nama folder sebagai Key
            tx.objectStore(STORE_NAME).put(handle, handle.name);
            return new Promise(r => tx.oncomplete = r);
        }

        async function getAllHandlesDB() {
            const db = await openDB();
            return new Promise(r => {
                const req = db.transaction(STORE_NAME).objectStore(STORE_NAME).getAll();
                req.onsuccess = () => r(req.result);
            });
        }
        
        async function clearDB() {
             const db = await openDB();
             const tx = db.transaction(STORE_NAME, 'readwrite');
             tx.objectStore(STORE_NAME).clear();
             return new Promise(r => tx.oncomplete = r);
        }
    </script>
    
    
    <script>
        // Cek database settings untuk background image
        fetch('api.php?action=get_settings').then(r=>r.json()).then(d => {
            if(d.bg_url) {
                document.body.style.backgroundImage = `url('${d.bg_url}')`;
                document.body.style.backgroundSize = "cover";
                document.body.style.backgroundPosition = "center";
                // Tambahkan overlay gelap supaya teks tetap terbaca
                const overlay = document.createElement('div');
                overlay.style.cssText = "position:absolute; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.8); z-index:-1;";
                document.body.appendChild(overlay);
            }
        });
    </script>
    
    
    <div id="trialWarning" style="display:none; position:fixed; bottom:0; left:0; width:100%; background: #b71c1c; color:white; text-align:center; padding:15px; z-index:9999; font-weight:bold; font-size:18px; border-top:3px solid gold; box-shadow:0 -5px 20px rgba(0,0,0,0.5);">
        ⚠️ MODE TRIAL: Logout otomatis dalam <span id="countdown" style="font-family:monospace; background:black; padding:2px 8px; border-radius:4px;">02:00</span>
        <button onclick="location.href='settings.php'" style="background:gold; color:black; border:none; padding:5px 15px; margin-left:15px; cursor:pointer; font-weight:bold; border-radius:4px;">🔑 MASUKKAN LISENSI</button>
    </div>

    <script>
        // --- 1. CEK LISENSI SAAT LOAD ---
        fetch('api.php?action=check_license')
        .then(r => r.json())
        .then(data => {
            if (data.status === 'valid') {
                console.log("Lisensi Valid Sampai: " + data.expiry);
                // Jika valid, hapus jejak timer trial agar bersih
                localStorage.removeItem('trial_start_ts');
            } else {
                console.warn("Lisensi Invalid/Kosong. Masuk Mode Trial.");
                startTrialTimer();
            }
        })
        .catch(() => startTrialTimer()); // Jika error koneksi, anggap trial

        function startTrialTimer() {
            const warning = document.getElementById('trialWarning');
            warning.style.display = 'block';
            
            const LIMIT_SECONDS = 120; // 2 Menit

            // Ambil waktu mulai dari memori browser
            let startTimestamp = localStorage.getItem('trial_start_ts');
            
            if (!startTimestamp) {
                // Jika belum ada (baru pertama buka), set waktu sekarang
                startTimestamp = Date.now();
                localStorage.setItem('trial_start_ts', startTimestamp);
            } else {
                startTimestamp = parseInt(startTimestamp);
            }

            // Update Timer setiap 1 detik
            const interval = setInterval(() => {
                const now = Date.now();
                const elapsed = Math.floor((now - startTimestamp) / 1000); // Detik berjalan
                const remaining = LIMIT_SECONDS - elapsed;

                if (remaining <= 0) {
                    // WAKTU HABIS
                    clearInterval(interval);
                    document.getElementById('countdown').innerText = "00:00";
                    forceLogout();
                } else {
                    // UPDATE TAMPILAN
                    const m = Math.floor(remaining / 60);
                    const s = remaining % 60;
                    document.getElementById('countdown').innerText = 
                        `0${m}:${s < 10 ? '0' : ''}${s}`;
                }
            }, 1000);
        }

        function forceLogout() {
            alert("WAKTU TRIAL HABIS! Silakan beli lisensi.");
            // Panggil API Logout untuk hancurkan Session PHP
            fetch('api.php?action=logout').then(() => {
                // Hapus item localstorage agar nanti tidak loop terus di login
                // (Opsional: Jika ingin user menderita trial habis terus, jangan hapus baris ini)
                // localStorage.removeItem('trial_start_ts'); 
                
                window.location.href = 'login.php';
            });
        }
    </script>
    
    
    
    <script>
    // --- AUDIO ENGINE: 5-BAND TONE CONTROL (HORIZONTAL) ---
    let audioCtx, audioSource, analyser;
    // Node Filter Khusus: Bass, Mid, Presence, Treble, Gain
    let bassNode, midNode, presenceNode, trebleNode, gainNode;
    let isAudioInit = false;

    // --- A. FUNGSI SIDEBAR ---
    function toggleSidebar() {
        const sidebar = document.getElementById('audioSidebar');
        sidebar.classList.toggle('open');
        if(!isAudioInit && typeof initAudioContext === 'function') initAudioContext();
    }

    // --- B. INISIALISASI AUDIO ---
    function initAudioContext() {
        if (isAudioInit) return;
        
        try {
            const AudioContext = window.AudioContext || window.webkitAudioContext;
            audioCtx = new AudioContext();
            const player = document.getElementById('player');
            
            // 1. Sumber Audio
            audioSource = audioCtx.createMediaElementSource(player);
            analyser = audioCtx.createAnalyser();
            analyser.fftSize = 256; 

            // 2. Buat 5 Node Filter Manual
            
            // BASS: LowShelf @ 200Hz (Untuk "Dug Dug")
            bassNode = audioCtx.createBiquadFilter();
            bassNode.type = 'lowshelf';
            bassNode.frequency.value = 200; 
            
            // VOKAL (MID): Peaking @ 1000Hz (Suara Dasar Manusia)
            midNode = audioCtx.createBiquadFilter();
            midNode.type = 'peaking';
            midNode.frequency.value = 1000;
            midNode.Q.value = 1.0; 

            // PRESENCE: Peaking @ 4000Hz (Kejelasan/Clarity & Attack)
            presenceNode = audioCtx.createBiquadFilter();
            presenceNode.type = 'peaking';
            presenceNode.frequency.value = 4000;
            presenceNode.Q.value = 1.0;

            // TREBLE: HighShelf @ 8000Hz (Kecerahan "Cess Cess")
            trebleNode = audioCtx.createBiquadFilter();
            trebleNode.type = 'highshelf';
            trebleNode.frequency.value = 8000;

            // VOLUME (GAIN)
            gainNode = audioCtx.createGain();
            gainNode.gain.value = 1.0; 

            // 3. Sambungkan Kabel Berurutan:
            // Source -> Bass -> Mid -> Presence -> Treble -> Gain -> Analyser -> Speaker
            audioSource.connect(bassNode);
            bassNode.connect(midNode);
            midNode.connect(presenceNode);
            presenceNode.connect(trebleNode);
            trebleNode.connect(gainNode);
            gainNode.connect(analyser);
            analyser.connect(audioCtx.destination);

            isAudioInit = true;
            visualize();
            console.log("Audio 5-Band Started");

        } catch (e) { console.error("Audio Init Gagal:", e); }
    }

    // --- C. UPDATE TONE ---
    function updateTone(type, val) {
        if(!isAudioInit) return;
        val = parseFloat(val);
        let displayVal = val;
        
        // Pilih node yang akan diubah
        let targetNode;
        if (type === 'bass') targetNode = bassNode;
        else if (type === 'mid') targetNode = midNode;
        else if (type === 'presence') targetNode = presenceNode;
        else if (type === 'treble') targetNode = trebleNode;
        
        // Set Nilai Gain (dB)
        if (targetNode) {
            targetNode.gain.value = val;
            displayVal = (val > 0 ? '+' : '') + val + 'dB';
        } 
        else if (type === 'gain') {
            gainNode.gain.value = val / 100; 
            displayVal = val + '%';
        }
        
        // Update Label UI
        const el = document.getElementById(`val-${type}`);
        if(el) {
            el.innerText = displayVal;
            // Warna Biru jika positif/aktif, Abu jika 0/standar
            el.style.color = (val == 0 && type !== 'gain') || (val == 100 && type === 'gain') ? '#888' : '#2196f3';
        }
    }

    function resetTone() {
        // Reset Slider UI
        const sliders = document.querySelectorAll('.horiz-slider');
        sliders.forEach(s => s.value = (s.getAttribute('max') == 200 ? 100 : 0));

        // Reset Audio Node
        if(isAudioInit) {
            bassNode.gain.value = 0;
            midNode.gain.value = 0;
            presenceNode.gain.value = 0;
            trebleNode.gain.value = 0;
            gainNode.gain.value = 1.0;
        }
        
        // Reset Label
        ['bass','mid','presence','treble'].forEach(t => document.getElementById(`val-${t}`).innerText = "0dB");
        document.getElementById('val-gain').innerText = "100%";
    }

    // --- D. VISUALIZER ---
    function visualize() {
        const canvas = document.getElementById('audioVis');
        if(!canvas || !analyser) return;
        const ctx = canvas.getContext('2d');
        const bufferLength = analyser.frequencyBinCount;
        const dataArray = new Uint8Array(bufferLength);

        function draw() {
            requestAnimationFrame(draw);
            analyser.getByteFrequencyData(dataArray);
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            if(canvas.width !== canvas.offsetWidth) {
                canvas.width = canvas.offsetWidth; canvas.height = canvas.offsetHeight;
            }
            const barWidth = (canvas.width / bufferLength) * 2.5;
            let x = 0;
            for (let i = 0; i < bufferLength; i++) {
                const barHeight = dataArray[i] / 2.0; 
                ctx.fillStyle = `rgba(33, 150, 243, ${barHeight/150 + 0.2})`; // Gelombang Biru
                ctx.fillRect(x, canvas.height - barHeight, barWidth, barHeight);
                x += barWidth + 1;
            }
        }
        draw();
    }
    
    // --- G. STARTUP ---
    window.addEventListener('DOMContentLoaded', () => { /* Ready */ });

    // --- F. SISTEM SUBTITLE & AI RECORDER (V2) ---
    let recognition;
    let isListening = false;
    let currentSubtitleTrack = null;
    
    // Variabel untuk merekam lirik
    let recordedCues = []; // Array untuk menyimpan [startTime, endTime, text]
    let lastCueTime = 0;
    let currentSongId = 0; // ID lagu yang sedang diputar

    // Helper: Format Detik ke Waktu VTT (00:00:05.000)
    function formatVTTTime(seconds) {
        let date = new Date(0);
        date.setSeconds(seconds);
        let timeStr = date.toISOString().substr(11, 8); // HH:MM:SS
        let ms = (seconds % 1).toFixed(3).substring(2); // .000
        return timeStr + "." + ms;
    }

    // Helper: Load Subtitle File (Jika Ada)
    async function checkSubtitle(songId) {
        currentSongId = songId; // Simpan ID untuk keperluan save nanti
        const player = document.getElementById('player');
        const display = document.getElementById('subtitleDisplay');
        
        display.innerText = "";
        
        // Hapus track lama
        if(currentSubtitleTrack) {
            currentSubtitleTrack.mode = 'disabled';
            player.innerHTML = ''; 
        }

        // Cek apakah file subtitle SUDAH ADA di server?
        try {
            const res = await fetch(`stream.php?id=${songId}&mode=subtitle`);
            if (res.ok) {
                // JIKA ADA FILE: Load file tersebut
                const blob = await res.blob();
                const url = URL.createObjectURL(blob);
                
                const track = document.createElement('track');
                track.kind = 'subtitles';
                track.srclang = 'id';
                track.src = url;
                track.default = true;
                player.appendChild(track);
                
                track.addEventListener('load', function() {
                    this.mode = 'hidden'; 
                    currentSubtitleTrack = player.textTracks[0];
                    currentSubtitleTrack.mode = 'hidden';
                    
                    // Tampilkan di layar
                    currentSubtitleTrack.oncuechange = function() {
                        const cue = this.activeCues[0];
                        display.innerText = cue ? cue.text : "";
                    };
                });
                
                // Sembunyikan tombol record karena sudah ada
                document.getElementById('btnAutoSub').innerText = "✅ SUBTITLE TERSEDIA";
                document.getElementById('btnAutoSub').disabled = true;
                document.getElementById('btnAutoSub').style.background = "#2e7d32";
                
            } else {
                // JIKA TIDAK ADA: Siapkan tombol Record AI
                document.getElementById('btnAutoSub').innerText = "🎙️ BUAT SUBTITLE (AI RECORD)";
                document.getElementById('btnAutoSub').disabled = false;
                document.getElementById('btnAutoSub').style.background = "#333";
            }
        } catch(e) { }
    }

    // --- UPDATE: FUNGSI AI & UPLOAD ---

    // 1. Cek Apakah User Pakai HP?
    function isMobile() {
        return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }

    // 2. Fungsi AI Live Caption (Update: Blokir HP)
    function toggleLiveCaption() {
        if (isMobile()) {
            alert("⚠️ FITUR TIDAK TERSEDIA DI HP\n\nSistem HP akan otomatis mematikan musik saat Mikrofon aktif. Harap gunakan PC/Laptop untuk membuat subtitle otomatis.");
            return;
        }

        const btn = document.getElementById('btnAutoSub');
        const display = document.getElementById('subtitleDisplay');
        const player = document.getElementById('player');

        if (!('webkitSpeechRecognition' in window)) {
            return alert("Gunakan Google Chrome Desktop untuk fitur ini.");
        }

        // --- STOP RECORDING & SAVE ---
        if (isListening) {
            recognition.stop();
            isListening = false;
            btn.innerText = "💾 MENYIMPAN SUBTITLE...";
            
            // Generate File VTT dari rekaman
            if (recordedCues.length > 0) {
                let vttContent = "WEBVTT\n\n";
                recordedCues.forEach(cue => {
                    vttContent += `${formatVTTTime(cue.start)} --> ${formatVTTTime(cue.end)}\n${cue.text}\n\n`;
                });

                // Kirim ke Server
                const fd = new FormData();
                fd.append('action', 'save_generated_subtitle');
                fd.append('id', currentSongId);
                fd.append('content', vttContent);

                fetch('api.php', { method: 'POST', body: fd })
                .then(r => r.json())
                .then(d => {
                    if(d.status === 'success') {
                        alert("SUKSES! Subtitle berhasil dibuat dan disimpan.\nLagu akan dimuat ulang agar subtitle muncul.");
                        // Reload lagu agar subtitle file terbaca
                        play(currentIndex); 
                    } else {
                        alert("GAGAL SIMPAN: " + d.msg);
                    }
                });
            } else {
                alert("Tidak ada suara yang terekam. Pastikan Stereo Mix aktif.");
                btn.innerText = "🎙️ BUAT SUBTITLE (AI RECORD)";
                btn.style.background = "#333";
            }
            return;
        }

        // --- START RECORDING ---
        recordedCues = []; // Reset memori rekaman
        lastCueTime = player.currentTime;
        
        recognition = new webkitSpeechRecognition();
        recognition.continuous = true;
        recognition.interimResults = true; 
        recognition.lang = 'id-ID'; 

        recognition.onstart = () => {
            isListening = true;
            btn.innerText = "🔴 PEREKAMAN AKTIF (KLIK UTK SIMPAN)";
            btn.style.background = "#c62828";
            display.innerText = "[Mendengarkan...]";
        };

        recognition.onresult = (event) => {
            let interimTranscript = '';
            const currentTime = player.currentTime;

            for (let i = event.resultIndex; i < event.results.length; ++i) {
                if (event.results[i].isFinal) {
                    const finalTranscript = event.results[i][0].transcript;
                    display.innerText = finalTranscript;
                    
                    // --- LOGIKA PEREKAMAN PINTAR ---
                    // Waktu mulai = Waktu terakhir selesai kalimat sebelumnya
                    // Waktu selesai = Waktu video sekarang
                    // (Kita beri sedikit buffer -0.5 detik agar pas)
                    let startTime = lastCueTime;
                    let endTime = currentTime;
                    
                    // Simpan ke array
                    recordedCues.push({
                        start: startTime,
                        end: endTime,
                        text: finalTranscript
                    });
                    
                    console.log(`Recorded: ${formatVTTTime(startTime)} -> ${formatVTTTime(endTime)} : ${finalTranscript}`);
                    
                    lastCueTime = endTime; // Update waktu terakhir
                    
                } else {
                    interimTranscript += event.results[i][0].transcript;
                    display.innerText = interimTranscript;
                }
            }
        };

        recognition.onerror = (event) => {
            console.error("AI Error:", event.error);
            if(event.error === 'not-allowed') alert("Izinkan akses mikrofon!");
        };
        
        recognition.onend = () => {
            // Jika mati sendiri tapi user belum klik stop, nyalakan lagi (continuous)
            if(isListening) recognition.start();
        };

        recognition.start();
    }
    
    
    // 3. FUNGSI BARU: UPLOAD SUBTITLE MANUAL
    function uploadSubtitleFile() {
        const fileInput = document.getElementById('subUpload');
        const file = fileInput.files[0];
        
        if (!file) return alert("Pilih file subtitle (.srt atau .vtt) dulu!");
        if (currentSongId <= 0) return alert("Putar lagu dulu agar sistem tahu upload untuk lagu apa.");

        const fd = new FormData();
        fd.append('action', 'upload_subtitle_file');
        fd.append('id', currentSongId);
        fd.append('subfile', file);

        // Tampilkan loading
        const btn = document.querySelector('button[onclick="uploadSubtitleFile()"]');
        const oldText = btn.innerText;
        btn.innerText = "⏳";
        btn.disabled = true;

        fetch('api.php', { method: 'POST', body: fd })
        .then(r => r.json())
        .then(d => {
            btn.innerText = oldText;
            btn.disabled = false;
            
            if(d.status === 'success') {
                alert("Subtitle berhasil diupload!");
                fileInput.value = ''; // Reset input
                // Reload lagu di detik yang sama
                const player = document.getElementById('player');
                const t = player.currentTime;
                play(currentIndex).then(() => {
                    document.getElementById('player').currentTime = t;
                });
            } else {
                alert("Gagal: " + d.msg);
            }
        })
        .catch(e => {
            alert("Error Upload: " + e);
            btn.innerText = oldText;
            btn.disabled = false;
        });
    }
    
    
    
    // Voice Changer Helper (Biarkan tetap ada)
    function setVoice(type) {
        const p = document.getElementById('player');
        p.mozPreservesPitch = false; p.webkitPreservesPitch = false; p.preservesPitch = false; 
        if (type === 'normal') { p.playbackRate = 1.0; p.preservesPitch = true; }
        else if (type === 'chipmunk') p.playbackRate = 1.3;
        else if (type === 'man') p.playbackRate = 0.85;
        else if (type === 'monster') p.playbackRate = 0.65;
    }





// --- SISTEM REMOTE CONTROL (VERSI DIAGNOSIS) ---

// 1. Tambahkan Indikator Status di Layar
const statusDiv = document.createElement('div');
statusDiv.style.cssText = "position:fixed; top:5px; right:5px; background:rgba(0,0,0,0.8); color:white; padding:5px 10px; font-size:10px; z-index:9999; border:1px solid #555;";
statusDiv.id = "remoteStatus";
statusDiv.innerHTML = "🔴 Remote: Disconnected";
document.body.appendChild(statusDiv);

// 2. Fungsi Tampilkan QR
function showRemoteQR() {
    document.getElementById('qrPopup').style.display = 'block';
    const qrContainer = document.getElementById('qrcode');
    qrContainer.innerHTML = ''; 

    // Auto-detect URL yang benar (cPanel friendly)
    const protocol = window.location.protocol;
    const host = window.location.host;         
    let path = window.location.pathname;
    path = path.substring(0, path.lastIndexOf("/"));
    
    // URL Remote
    const fullUrl = `${protocol}//${host}${path}/remote.php`;
    console.log("Remote URL:", fullUrl);

    new QRCode(qrContainer, { text: fullUrl, width: 150, height: 150 });
    document.getElementById('ipLink').innerHTML = `<a href="${fullUrl}" target="_blank" style="color:gold">${fullUrl}</a>`;
}

// 3. Polling Server (Cek Perintah)
setInterval(() => {
    fetch('api.php?action=remote_poll')
    .then(r => r.json())
    .then(d => {
        // Update Indikator: Hijau kedip artinya koneksi lancar
        const time = new Date().toLocaleTimeString();
        document.getElementById('remoteStatus').innerHTML = `🟢 Remote: Connected (${time})`;
        document.getElementById('remoteStatus').style.borderColor = "#2e7d32";

        // Jika ada perintah
        if(d.status === 'command') {
            console.log("Perintah Diterima:", d.cmd, d.val);
            // Tampilkan notifikasi di layar agar user tahu perintah masuk
            document.getElementById('remoteStatus').innerHTML = `⚡ EXECUTE: ${d.cmd}`;
            document.getElementById('remoteStatus').style.backgroundColor = "#d4af37";
            document.getElementById('remoteStatus').style.color = "black";
            
            setTimeout(() => { 
               document.getElementById('remoteStatus').style.backgroundColor = "rgba(0,0,0,0.8)"; 
               document.getElementById('remoteStatus').style.color = "white"; 
            }, 1000);

            executeRemote(d.cmd, d.val);
        }
    })
    .catch(err => {
        // Jika error, indikator jadi merah
        document.getElementById('remoteStatus').innerHTML = `🔴 Error: ${err.message}`;
        document.getElementById('remoteStatus').style.borderColor = "red";
    });
}, 1000); // Cek tiap 1 detik

// --- FUNGSI LENGKAP: EXECUTE REMOTE (INDEX.PHP) ---
function executeRemote(cmd, val) {
            const p = document.getElementById('player');
            try {
                // ... (Kode Play, Pause, Vol, EQ, Pitch biarkan sama) ...
                if(cmd === 'play') p.play();
                if(cmd === 'pause') p.pause();
                if(cmd === 'volume') { if(typeof updateTone === 'function') updateTone('gain', val); else p.volume = val / 100; }
                if(cmd === 'next') if(typeof play === 'function') play(currentIndex + 1);
                if(cmd === 'eq_bass') updateTone('bass', val);
                if(cmd === 'eq_treble') updateTone('treble', val);
                if(cmd === 'pitch') { let r=1.0; if(val=='1') r=1.1; if(val=='-1') r=0.9; p.playbackRate=r; }
                
                // Add Queue
                if(cmd === 'queue_add') addToQueue(val);

                // Mode
                if(cmd === 'mode_yt') location.href = 'youtube.php';
                if(cmd === 'mode_local') location.reload();
                if(cmd === 'fullscreen') {
                    document.body.classList.toggle('cinema-active');
                    if (!document.fullscreenElement) document.documentElement.requestFullscreen().catch(()=>{});
                }

                // --- LOAD PLAYLIST UTUH ---
                if(cmd === 'load_pl') {
                    fetch('api.php?action=load_playlist_items&id=' + val).then(r=>r.json()).then(titles => {
                        currentLoadedPlId = val;
                        queue = titles.map(t => ({ title: t.title })); 
                        saveQueueLocal();
                        renderQueue();
                        renderLibrary(); // Update library view
                        if(queue.length > 0) play(0);
                    });
                }

                // --- BARU: LOAD PLAYLIST & JUMP KE LAGU TERTENTU ---
                if(cmd === 'load_pl_jump') {
                    const parts = val.split('|'); // Format: ID|INDEX
                    const plId = parts[0];
                    const jumpIdx = parseInt(parts[1]);

                    fetch('api.php?action=load_playlist_items&id=' + plId).then(r=>r.json()).then(titles => {
                        queue = titles.map(t => ({ title: t.title })); 
                        saveQueueLocal();
                        renderQueue();
                        renderLibrary();
                        // Putar langsung index yang diminta
                        if(queue.length > jumpIdx) play(jumpIdx);
                    });
                }

            } catch (e) { console.error(e); }
        }

    
</script>
   
   
   <div id="billingOverlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:black; z-index:99999; flex-direction:column; justify-content:center; align-items:center; color:white; text-align:center;">
    <h1 style="font-size:50px; color:red; margin:0;">WAKTU HABIS</h1>
    <p>Silakan hubungi Admin/Kasir untuk menambah waktu.</p>
    <div id="timerCountdown" style="font-family:monospace; font-size:20px; color:gold; margin-top:20px;"></div>
</div>

<div id="marqueeContainer" style="display:none; position:fixed; top:0; left:0; width:100%; background:rgba(0,0,0,0.8); color:#d4af37; z-index:99990; font-weight:bold; font-size:24px; padding:10px 0; border-bottom:2px solid gold; overflow:hidden; white-space:nowrap; pointer-events:none;">
    <div id="marqueeText" style="display:inline-block; padding-left:100%; animation: scroll-text 15s linear infinite;">
        Selamat Datang di Karaoke Kami!
    </div>
</div>

<style>
@keyframes scroll-text {
    0% { transform: translateX(0); }
    100% { transform: translateX(-100%); }
}
/* Pastikan Marquee tetap di atas elemen lain */
body.cinema-active #marqueeContainer { display: block !important; } 
</style>

<script>
    // FUNGSI UPDATE PLAYER (TIMER & TEXT)
    // Ganti interval timer yang lama dengan yang ini agar lebih efisien (1 request 2 data)
    setInterval(updatePlayerInfo, 5000);

    function updatePlayerInfo() {
        fetch('api.php?action=get_player_info')
        .then(r => r.json())
        .then(data => {
            // 1. UPDATE TIMER (Overlay Hitam)
            const overlay = document.getElementById('billingOverlay');
            // Cek variabel 'player' (untuk youtube) atau elemen (untuk local)
            const ytPlayerObj = (typeof player !== 'undefined') ? player : null; 
            const locPlayer = document.getElementById('player');

            if (data.timer_status === 'expired') {
                if (overlay.style.display === 'none') {
                    overlay.style.display = 'flex';
                    if(ytPlayerObj && ytPlayerObj.pauseVideo) ytPlayerObj.pauseVideo();
                    if(locPlayer) locPlayer.pause();
                }
            } else {
                overlay.style.display = 'none';
            }

            // 2. UPDATE RUNNING TEXT
            const mq = document.getElementById('marqueeContainer');
            const txt = document.getElementById('marqueeText');
            
            if(data.running_text && data.running_text.trim() !== "") {
                if(txt.innerText !== data.running_text) txt.innerText = data.running_text;
                mq.style.display = 'block';
            } else {
                mq.style.display = 'none';
            }
        });
    }
    updatePlayerInfo(); // Run once on load
</script>
    
</body>
</html>