<?php
session_start();
include 'config_path.php';

// Auto Login jika ada Cookie
if (!isset($_SESSION['user']) && isset($_COOKIE['k_user'])) {
    $u = mysqli_real_escape_string($conn, $_COOKIE['k_user']);
    $q = mysqli_query($conn, "SELECT * FROM users WHERE username='$u'");
    if(mysqli_num_rows($q) > 0) {
        $_SESSION['user'] = $u;
        header("Location: index.php");
        exit;
    }
}

if (isset($_SESSION['user'])) {
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <style>
        body { background: #111; color: gold; font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; margin:0; }
        .box { border: 1px solid gold; padding: 30px; border-radius: 8px; background: #222; width: 300px; text-align: center; box-shadow: 0 0 20px rgba(212, 175, 55, 0.2); }
        input { width: 90%; padding: 10px; margin: 10px 0; background: #000; border: 1px solid #444; color: white; text-align:center; }
        button { width: 100%; padding: 10px; background: gold; border: none; font-weight: bold; cursor: pointer; margin-top:10px; border-radius:4px; }
        button:hover { background: #ffdc5e; }
    </style>
</head>
<body>
    <div class="box">
        <h2 style="font-family:monospace; margin-top:0;">SYSTEM ACCESS</h2>
        <p id="msg" style="color:red; font-size:12px; min-height:15px;"></p>
        <input type="text" id="user" placeholder="Username">
        <input type="password" id="pass" placeholder="Password">
        <label style="display:block; text-align:left; font-size:12px; margin:10px 0; color:#aaa;">
            <input type="checkbox" id="remember" style="width:auto;"> Ingat Saya
        </label>
        <button onclick="login()">MASUK</button>
    </div>
    <script>
        document.getElementById('pass').addEventListener('keypress', function (e) {
            if (e.key === 'Enter') login();
        });

        function login() {
            const u = document.getElementById('user').value;
            const p = document.getElementById('pass').value;
            const r = document.getElementById('remember').checked;
            
            const fd = new FormData();
            fd.append('action', 'login_check');
            fd.append('username', u);
            fd.append('password', p);
            
            fetch('api.php', { method: 'POST', body: fd })
            .then(res => res.json())
            .then(d => {
                if(d.status === 'success') {
                    // --- [PERBAIKAN UTAMA DISINI] ---
                    // Hapus ingatan timer trial lama agar saat masuk tidak langsung logout lagi
                    localStorage.removeItem('trial_start_ts'); 
                    // --------------------------------

                    if(r) {
                        const date = new Date();
                        date.setTime(date.getTime() + (30*24*60*60*1000));
                        document.cookie = "k_user=" + u + "; expires=" + date.toUTCString() + "; path=/";
                    }
                    window.location.href = "index.php";
                } else {
                    document.getElementById('msg').innerText = "Username atau Password Salah!";
                }
            });
        }
    </script>
</body>
</html>