<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Remote Karaoke</title>
    <style>
        body { background: #121212; color: #ddd; font-family: sans-serif; margin:0; padding:15px; user-select:none; }
        h3 { color: #d4af37; text-align:center; border-bottom:1px solid #333; padding-bottom:10px; margin-top:0; }
        
        /* GRID & BUTTONS */
        .grid-btn { display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px; margin-bottom: 20px; }
        .btn { background: #333; color: white; border: none; padding: 15px 0; border-radius: 8px; font-weight: bold; font-size: 14px; cursor: pointer; }
        .btn:active { background: #d4af37; color: black; }
        .btn-red { background: #c62828; }
        .btn-blue { background: #1565c0; }
        .btn-green { background: #2e7d32; }
        .btn-gold { background: #fbc02d; color: black; }
        
        /* SLIDER & INPUT */
        .slider-box { background:#222; padding:10px; border-radius:8px; margin-bottom:10px; }
        input[type=range] { width:100%; }
        #searchBox, #plSearchBox { width:100%; padding:12px; background:#000; border:1px solid #444; color:white; border-radius:8px; font-size:16px; box-sizing: border-box; margin-bottom: 10px; }
        
        /* LIST STYLES */
        .scroll-area { margin-top:10px; max-height:400px; overflow-y:auto; }
        .song-item { padding:10px; border-bottom:1px solid #333; background: #1e1e1e; margin-bottom: 2px; }
        .song-info { font-size: 14px; font-weight:bold; color:#eee; margin-bottom:5px; }
        .btn-group { display:flex; gap:5px; margin-top:5px; }
        .btn-sm { padding:6px 10px; font-size:11px; border-radius:4px; border:none; color:white; cursor:pointer; flex:1; }
        
        /* TABS */
        .tabs { display:flex; margin-bottom:15px; border-bottom:1px solid #444; }
        .tab { flex:1; padding:10px; text-align:center; background:#1a1a1a; cursor:pointer; font-size:12px; }
        .tab.active { background:#333; color:#d4af37; font-weight:bold; border-bottom:2px solid #d4af37; }

        /* PLAYLIST DETAIL HEADER */
        .pl-header { display: flex; gap: 10px; margin-bottom: 10px; align-items: center; background: #222; padding: 10px; border-radius: 8px; }
    </style>
</head>
<body>

    <h3>📱 REMOTE CONTROL</h3>

    <div class="tabs">
        <div class="tab active" onclick="switchTab('main')">KONTROL</div>
        <div class="tab" onclick="switchTab('songs')">CARI</div>
        <div class="tab" onclick="switchTab('playlist')">PLAYLIST</div>
        <div class="tab" onclick="switchTab('fx')">AUDIO FX</div>
        <div class="tab" onclick="switchTab('timer')">⏱️ TIMER</div>
    </div>

    <div id="view-main">
        <div class="grid-btn">
            <button class="btn" onclick="cmd('play')">▶ PLAY</button>
            <button class="btn" onclick="cmd('pause')">⏸ PAUSE</button>
            <button class="btn btn-red" onclick="cmd('next')">⏭ NEXT</button>
        </div>
        <div class="slider-box">
            <label style="font-size:12px; color:#aaa;">🔊 VOLUME UTAMA</label>
            <input type="range" min="0" max="100" value="100" onchange="cmd('volume', this.value)">
        </div>
        <div class="grid-btn">
            <button class="btn btn-blue" onclick="cmd('mode_local')">🏠 LOCAL</button>
            <button class="btn btn-red" onclick="cmd('mode_yt')">📺 YOUTUBE</button>
            <button class="btn" style="background:#555" onclick="cmd('fullscreen')">🖥️ FULL</button>
        </div>
    </div>

    <div id="view-songs" style="display:none;">
        <div style="display:flex; gap:5px; margin-bottom:10px;">
            <button id="btnSrcDb" class="btn" style="padding:5px; font-size:12px; background:#d4af37; color:black;" onclick="setSearchSource('db')">📂 DATABASE</button>
            <button id="btnSrcYt" class="btn" style="padding:5px; font-size:12px; background:#333;" onclick="setSearchSource('yt')">📺 YOUTUBE</button>
        </div>
        <input type="text" id="searchBox" placeholder="Cari Lagu..." oninput="handleSearch()">
        <div id="resList" class="scroll-area"></div>
    </div>
    
    <div id="view-playlist" style="display:none;">
        
        <div id="pl-list-view">
            <button class="btn btn-green" style="width:100%; margin-bottom:10px;" onclick="createNewPlaylist()">➕ BUAT PLAYLIST BARU</button>
            
            <div style="display:flex; gap:5px; margin-bottom:10px;">
                <button class="btn" onclick="loadRemotePlaylists('local')" style="padding:8px; font-size:12px; background:#1565c0;">📂 SAVED LOCAL</button>
                <button class="btn" onclick="loadRemotePlaylists('youtube')" style="padding:8px; font-size:12px; background:#c62828;">📺 SAVED YOUTUBE</button>
            </div>
            <div id="playListArea" class="scroll-area"></div>
        </div>

        <div id="pl-detail-view" style="display:none;">
            <div class="pl-header">
                <button class="btn" style="padding:5px 10px; background:#444;" onclick="backToPlList()">⬅ Back</button>
                <span id="plTitleDisplay" style="font-weight:bold; font-size:14px; color:gold;">Nama Playlist</span>
            </div>
            <input type="text" id="plSearchBox" placeholder="Cari dalam playlist ini..." oninput="filterPlaylistItems()">
            <button class="btn btn-green" style="width:100%; margin-bottom:10px; padding:10px;" onclick="cmd('load_pl', currentPlId)">📂 MUAT SEMUA KE LAYAR</button>
            <div id="plItemsArea" class="scroll-area"></div>
        </div>
    </div>

    <div id="view-fx" style="display:none;">
        <div class="slider-box">
            <label style="font-size:12px; color:#aaa;">🎹 PITCH / NADA</label>
            <div style="display:flex; justify-content:space-between; margin-top:5px;">
                <button class="btn" style="width:40px; padding:5px;" onclick="cmd('pitch', '-1')">-</button>
                <button class="btn" style="width:100px; padding:5px;" onclick="cmd('pitch', '0')">NORMAL</button>
                <button class="btn" style="width:40px; padding:5px;" onclick="cmd('pitch', '1')">+</button>
            </div>
        </div>
        <div class="slider-box">
            <label style="font-size:12px; color:#aaa;">🎚️ BASS & TREBLE</label>
            <input type="range" min="-10" max="10" value="0" onchange="cmd('eq_bass', this.value)" style="margin-bottom:10px">
            <input type="range" min="-10" max="10" value="0" onchange="cmd('eq_treble', this.value)">
        </div>
    </div>



<div id="view-timer" style="display:none;">
        <div class="slider-box" style="text-align:center;">
            <h3 style="color:#2196f3; border:none;">⏱️ BILLING CONTROL</h3>
            <p style="font-size:12px; color:#aaa;">Kontrol durasi sewa dari jarak jauh.<br>Password admin diperlukan untuk eksekusi.</p>
            
            <input type="number" id="remoteTimerInput" placeholder="Masukkan Menit (Cth: 60)" style="padding:15px; width:100%; box-sizing:border-box; margin-bottom:10px; background:#000; border:1px solid #444; color:white; text-align:center; font-size:18px; border-radius:8px;">

            <div class="grid-btn" style="grid-template-columns: 1fr 1fr;">
                <button class="btn btn-blue" onclick="secureTimer('set')">SET BARU</button>
                <button class="btn btn-green" onclick="secureTimer('add')">TAMBAH (+)</button>
            </div>

            <button class="btn btn-red" onclick="secureTimer('stop')" style="width:100%; margin-top:10px;">⛔ STOP / MATIKAN SESI</button>
        </div>
        
        
        
        
        

        
        
        <div style="margin-top:20px; text-align:center; font-size:12px; color:#555;">
            Status koneksi timer: <span id="timerStatusRemote">Checking...</span>
        </div>
        
        <div class="slider-box" style="margin-top:20px;">
        <label style="font-size:12px; color:#aaa;">📢 RUNNING TEXT (PESAN LAYAR)</label>
        <textarea id="runTextInput" rows="2" placeholder="Ketik pesan disini..." style="width:100%; background:#000; color:gold; border:1px solid #444; padding:5px; margin-top:5px;"></textarea>
        <button class="btn" style="margin-top:5px; background:#444;" onclick="sendRunningText()">KIRIM PESAN</button>
        <button class="btn btn-red" style="margin-top:5px;" onclick="sendRunningText(true)">HAPUS PESAN</button>
    </div>
        
    </div>

    <div id="passModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.9); z-index:10000; justify-content:center; align-items:center;">
        <div style="background:#222; padding:20px; border-radius:10px; border:1px solid gold; width:80%; max-width:300px; text-align:center;">
            <h4 style="color:gold; margin-top:0;">🔒 ADMIN ACCESS</h4>
            <p style="color:#ccc; font-size:12px;">Masukkan Password Login Admin:</p>
            <input type="password" id="adminPassInput" style="width:100%; padding:10px; box-sizing:border-box; margin-bottom:10px; background:#000; color:white; border:1px solid #555;">
            <div style="display:flex; gap:10px;">
                <button class="btn" style="background:#444;" onclick="closePassModal()">BATAL</button>
                <button class="btn btn-gold" onclick="submitSecureAction()">OK</button>
            </div>
        </div>
    </div>

<script>
    function sendRunningText(clear = false) {
        let text = document.getElementById('runTextInput').value;
        if(clear) { text = ""; document.getElementById('runTextInput').value = ""; }
        
        const fd = new FormData();
        fd.append('action', 'save_running_text');
        fd.append('text', text);
        
        fetch('api.php', { method:'POST', body:fd }).then(r=>r.json()).then(d=>{
            alert(clear ? "Pesan dihapus!" : "Pesan dikirim ke layar!");
        });
    }
</script>

<script>
    function switchTab(name) {
        ['main','songs','playlist','fx'].forEach(t => document.getElementById('view-'+t).style.display='none');
        document.getElementById('view-'+name).style.display='block';
        document.querySelectorAll('.tab').forEach(e => e.classList.remove('active'));
        event.target.classList.add('active');
    }

    function cmd(command, value = '') {
        const fd = new FormData();
        fd.append('action', 'remote_send');
        fd.append('cmd', command);
        fd.append('val', value);
        if(navigator.vibrate) navigator.vibrate(50);
        fetch('api.php', { method: 'POST', body: fd });
    }

    // --- SEARCH ---
    let searchSource = 'db'; let debounce;
    function setSearchSource(mode) {
        searchSource = mode;
        document.getElementById('btnSrcDb').style.background = mode==='db' ? '#d4af37' : '#333';
        document.getElementById('btnSrcDb').style.color = mode==='db' ? 'black' : 'white';
        document.getElementById('btnSrcYt').style.background = mode==='yt' ? 'red' : '#333';
        document.getElementById('resList').innerHTML = ''; 
    }
    function handleSearch() {
        clearTimeout(debounce);
        const q = document.getElementById('searchBox').value;
        if(!q) return;
        debounce = setTimeout(() => {
            const div = document.getElementById('resList');
            div.innerHTML = '<div style="padding:10px; text-align:center">Mencari...</div>';
            if (searchSource === 'db') {
                fetch('api.php?action=get_all_songs').then(r=>r.json()).then(data => {
                    div.innerHTML = '';
                    const filtered = data.filter(s => s.title.toLowerCase().includes(q.toLowerCase())).slice(0,20);
                    filtered.forEach(s => {
                        const el = document.createElement('div');
                        el.className = 'song-item';
                        el.innerHTML = `<div class="song-info">${s.title}</div><button class="btn-sm btn-green" onclick="cmd('queue_add', '${s.title}')">TAMBAH</button>`;
                        div.appendChild(el);
                    });
                });
            } else {
                const fd = new FormData(); fd.append('action', 'remote_yt_search'); fd.append('query', q);
                fetch('api.php', { method:'POST', body:fd }).then(r=>r.json()).then(data => {
                    div.innerHTML = '';
                    if(data.error) { div.innerHTML = `Error: ${data.error}`; return; }
                    data.items.forEach(item => {
                        const vidId = item.id.videoId;
                        const title = item.snippet.title.replace(/'/g, "");
                        const payload = JSON.stringify({ id: vidId, title: title });
                        const el = document.createElement('div');
                        el.className = 'song-item';
                        el.innerHTML = `
                            <img src="${item.snippet.thumbnails.default.url}" style="width:50px; height:35px; object-fit:cover; margin-right:10px;">
                            <div style="flex:1; overflow:hidden;">
                                <div class="song-info" style="font-size:12px;">${item.snippet.title}</div>
                                <div style="display:flex; gap:5px;">
                                    <button class="btn-sm btn-green" onclick='cmd("queue_add_yt", \`${payload}\`)'>+ LIST</button>
                                    <button class="btn-sm btn-red" onclick="cmd('play_yt_direct', '${vidId}')">▶ PLAY</button>
                                </div>
                            </div>`;
                        div.appendChild(el);
                    });
                });
            }
        }, 1000);
    }

    // --- PLAYLIST MANAGER ---
    let currentPlItems = []; let currentPlId = 0; let currentPlType = '';

    // [FITUR BARU] BUAT PLAYLIST
    function createNewPlaylist() {
        const name = prompt("Masukkan Nama Playlist Baru:");
        if(!name) return;

        // Tanya Tipe (Lokal / YouTube)
        const isLocal = confirm("Pilih Tipe Playlist:\n\nOK = Playlist LOKAL\nCancel = Playlist YOUTUBE");
        const type = isLocal ? 'local' : 'youtube';

        const fd = new FormData();
        fd.append('action', 'save_playlist');
        fd.append('name', name);
        fd.append('type', type);
        fd.append('songs', '[]'); // Playlist kosong

        fetch('api.php', { method: 'POST', body: fd })
        .then(r=>r.json())
        .then(d => {
            if(d.status === 'success') {
                alert("Playlist berhasil dibuat!");
                loadRemotePlaylists(type);
            } else {
                alert("Gagal: " + d.msg);
            }
        });
    }

    function loadRemotePlaylists(type) {
        const div = document.getElementById('playListArea');
        currentPlType = type;
        div.innerHTML = '<div style="text-align:center; padding:20px;">Memuat...</div>';
        fetch('api.php?action=get_playlists&type=' + type).then(r => r.json()).then(data => {
            div.innerHTML = '';
            if(data.length === 0) { div.innerHTML = '<div style="text-align:center; padding:20px; color:#555;">Tidak ada playlist.</div>'; return; }
            data.forEach(p => {
                const el = document.createElement('div');
                el.className = 'song-item';
                el.innerHTML = `
                    <div style="width:100%">
                        <div class="song-info">💿 ${p.name}</div>
                        <div class="btn-group">
                            <button class="btn-sm" style="background:#444" onclick="viewPlaylistDetails(${p.id}, '${p.name}')">👁 ISI</button>
                            <button class="btn-sm btn-blue" onclick="renamePlaylist(${p.id}, '${p.name}')">✏ EDIT</button>
                            <button class="btn-sm btn-red" onclick="deletePlaylist(${p.id})">🗑 HAPUS</button>
                            <button class="btn-sm btn-gold" onclick="loadPlCmd(${p.id})">▶ LOAD</button>
                        </div>
                    </div>`;
                div.appendChild(el);
            });
        });
    }

    function deletePlaylist(id) {
        if(!confirm("Yakin hapus playlist ini selamanya?")) return;
        const fd = new FormData(); fd.append('action', 'delete_playlist'); fd.append('id', id);
        fetch('api.php', {method:'POST', body:fd}).then(r=>r.json()).then(d=>{
            if(d.status==='success') loadRemotePlaylists(currentPlType);
            else alert("Gagal hapus");
        });
    }

    function renamePlaylist(id, oldName) {
        const newName = prompt("Nama Baru:", oldName);
        if(!newName || newName === oldName) return;
        const fd = new FormData(); fd.append('action', 'rename_playlist'); fd.append('id', id); fd.append('name', newName);
        fetch('api.php', {method:'POST', body:fd}).then(r=>r.json()).then(d=>{
            if(d.status==='success') loadRemotePlaylists(currentPlType);
            else alert("Gagal ubah nama");
        });
    }

    function viewPlaylistDetails(id, name) {
        currentPlId = id;
        document.getElementById('pl-list-view').style.display = 'none';
        document.getElementById('pl-detail-view').style.display = 'block';
        document.getElementById('plTitleDisplay').innerText = name;
        document.getElementById('plItemsArea').innerHTML = '<div style="text-align:center;">Loading...</div>';
        fetch('api.php?action=load_playlist_items&id=' + id).then(r => r.json()).then(items => {
            currentPlItems = items; renderPlaylistItems(items);
        });
    }
    function renderPlaylistItems(items) {
        const div = document.getElementById('plItemsArea');
        div.innerHTML = '';
        items.forEach((item, idx) => {
            const el = document.createElement('div');
            el.className = 'song-item';
            el.innerHTML = `<div class="song-info">${idx+1}. ${item.title}</div><button class="btn-sm btn-red" style="width:auto; flex:none;" onclick="cmd('load_pl_jump', '${currentPlId}|${idx}')">▶</button>`;
            div.appendChild(el);
        });
    }
    function filterPlaylistItems() {
        const q = document.getElementById('plSearchBox').value.toLowerCase();
        renderPlaylistItems(currentPlItems.filter(i => i.title.toLowerCase().includes(q)));
    }
    function backToPlList() { document.getElementById('pl-detail-view').style.display = 'none'; document.getElementById('pl-list-view').style.display = 'block'; }
    function loadPlCmd(id) { if(confirm("Muat Playlist ini?")) { cmd('load_pl', id); } }
    
    
    
    // --- TAMBAHAN: LOGIKA SWITCH TAB ---
    // Pastikan nama 'timer' dimasukkan ke array reset display
    function switchTab(name) {
        ['main','songs','playlist','fx','timer'].forEach(t => document.getElementById('view-'+t).style.display='none');
        document.getElementById('view-'+name).style.display='block';
        document.querySelectorAll('.tab').forEach(e => e.classList.remove('active'));
        event.target.classList.add('active');

        // Jika buka tab timer, cek status sisa waktu
        if(name === 'timer') checkRemoteTimerStatus();
    }

    // --- TAMBAHAN: LOGIKA SECURE TIMER ---
    let pendingAction = ''; // Menyimpan aksi apa yang mau dilakukan (set/add/stop)

    function secureTimer(action) {
        pendingAction = action;
        // Tampilkan Modal Password
        document.getElementById('passModal').style.display = 'flex';
        document.getElementById('adminPassInput').value = '';
        document.getElementById('adminPassInput').focus();
    }

    function closePassModal() {
        document.getElementById('passModal').style.display = 'none';
        pendingAction = '';
    }

    function submitSecureAction() {
        const pass = document.getElementById('adminPassInput').value;
        const mins = document.getElementById('remoteTimerInput').value;
        
        if(!pass) return alert("Password wajib diisi!");
        if((pendingAction !== 'stop') && !mins) return alert("Masukkan jumlah menit!");

        // Kirim ke API dengan validasi Password
        const fd = new FormData();
        fd.append('action', 'secure_timer_remote'); // Action khusus baru
        fd.append('password', pass);
        fd.append('mode', pendingAction); // set, add, atau stop
        fd.append('minutes', mins || 0);

        fetch('api.php', { method: 'POST', body: fd })
        .then(r => r.json())
        .then(d => {
            if(d.status === 'success') {
                alert("Berhasil: " + d.msg);
                closePassModal();
                checkRemoteTimerStatus(); // Update status
            } else {
                alert("GAGAL: " + d.msg); // Biasanya karena password salah
            }
        })
        .catch(e => alert("Error koneksi"));
    }

    function checkRemoteTimerStatus() {
        fetch('api.php?action=check_timer_status')
        .then(r => r.json())
        .then(d => {
            const el = document.getElementById('timerStatusRemote');
            if(d.status === 'expired') el.innerHTML = "<span style='color:red'>HABIS / MATI</span>";
            else {
                let m = Math.floor(d.remaining / 60);
                el.innerHTML = `<span style='color:#00e676'>AKTIF: Sisa ${m} Menit</span>`;
            }
        });
    }
    
</script>
</body>
</html>