<?php
session_start();
if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Pengaturan</title>
    <style>
        body { background: #121212; color: #ddd; font-family: sans-serif; padding: 20px; }
        .box { max-width: 500px; margin: 0 auto; background: #222; padding: 20px; border-radius: 8px; border: 1px solid #444; }
        label { display: block; margin-top: 15px; font-weight: bold; color:#d4af37; }
        input { width: 100%; padding: 10px; margin-top: 5px; background: #000; border: 1px solid #555; color: white; box-sizing: border-box; }
        button { margin-top: 10px; padding: 10px; width: 100%; cursor: pointer; border: none; font-weight: bold; border-radius: 4px; }
        .btn-save { background: #2e7d32; color: white; }
        .btn-danger { background: #c62828; color: white; margin-top: 30px; padding: 15px; }
        .btn-back { background: #444; color: white; margin-bottom: 20px; }
        .btn-pass { background: #1565c0; color: white; }
        small { font-size: 11px; color:#888; }
        hr { border-color:#444; margin: 20px 0; }
    </style>
</head>
<body>

<div class="box">
    <button class="btn-back" onclick="location.href='index.php'">⬅ KEMBALI</button>
    
    <h2 style="border-bottom:1px solid #444; padding-bottom:10px;">⚙️ PENGATURAN</h2>

    <label>URL Background</label>
    <small>Link gambar (jpg/png) untuk latar belakang.</small>
    <input type="text" id="bg_url" placeholder="https://...">
    <button class="btn-save" onclick="save('bg_url')">SIMPAN BACKGROUND</button>

    <label>API Key YouTube</label>
    <small>Wajib untuk fitur pencarian YouTube.</small>
    <input type="text" id="yt_api_key" placeholder="AIza...">
    <button class="btn-save" onclick="save('yt_api_key')">SIMPAN API KEY</button>
    
    <hr>

    <label>🔒 Ganti Password Login</label>
    <input type="password" id="new_pass" placeholder="Password Baru...">
    <button class="btn-pass" onclick="changePass()">UBAH PASSWORD</button>

    <hr>

    <label>🔑 LICENSE KEY</label>
    <small>Masukkan kode dari generator lisensi untuk menghilangkan Trial Mode.</small>
    <input type="text" id="license_key" placeholder="Kode Lisensi...">
    <button class="btn-save" onclick="save('license_key')">AKTIFKAN LISENSI</button>

    <button class="btn-danger" onclick="resetAll()">⚠️ HAPUS SEMUA DATA (RESET PABRIK)</button>
    
    
    <hr>
    <label style="color:#2196f3;">⏱️ PENGATURAN TIMER RENTAL</label>
    <small>Masukkan durasi sewa (dalam menit). Isi 0 untuk mematikan.</small>
    <div style="display:flex; gap:5px;">
        <input type="number" id="timer_minutes" placeholder="Contoh: 60" style="text-align:center;">
        <button class="btn-save" style="background:#2196f3; width:auto;" onclick="setTimer()">SET BARU</button>
        <button class="btn-save" style="background:#4caf50; width:auto;" onclick="addTimer()">TAMBAH (+)</button>
    </div>
    <div style="margin-top:5px; text-align:center;">
        <button onclick="setTimer(0)" style="background:#c62828; color:white; padding:5px; border:none; cursor:pointer; width:100%;">⛔ STOP / WAKTU HABIS</button>
    </div>
    <hr>
    
    
    <hr>
    <label style="color:#00e676;">💰 TARIF & LAPORAN PENDAPATAN</label>
    
    <small>Harga Sewa Per Jam (Rupiah):</small>
    <div style="display:flex; gap:5px; margin-bottom:15px;">
        <input type="number" id="inputRate" placeholder="Contoh: 50000">
        <button class="btn-save" onclick="saveRate()" style="width:auto;">SIMPAN HARGA</button>
    </div>

    <div style="background:#000; padding:10px; border:1px solid #333; border-radius:4px;">
        <div style="display:flex; justify-content:space-between; margin-bottom:5px;">
            <strong style="color:white;">Hari Ini (<span id="todayDate"></span>)</strong>
            <button onclick="loadReport()" style="background:none; border:none; color:gold; cursor:pointer;">🔄 Refresh</button>
        </div>
        <table style="width:100%; font-size:12px; color:#ccc; border-collapse:collapse;">
            <thead>
                <tr style="border-bottom:1px solid #555; text-align:left;">
                    <th>Jam</th>
                    <th>Durasi</th>
                    <th>Ket</th>
                    <th style="text-align:right;">Rp</th>
                </tr>
            </thead>
            <tbody id="reportList"></tbody>
            <tfoot>
                <tr style="border-top:1px solid #d4af37; font-weight:bold; color:#00e676;">
                    <td colspan="3">TOTAL PENDAPATAN</td>
                    <td style="text-align:right;" id="totalRevenue">0</td>
                </tr>
            </tfoot>
        </table>
    </div>
    
    
</div>


<script>
    // --- SCRIPT LAPORAN ---
    function saveRate() {
        const r = document.getElementById('inputRate').value;
        const fd = new FormData(); fd.append('action', 'save_rate'); fd.append('rate', r);
        fetch('api.php', {method:'POST', body:fd}).then(()=>alert("Harga tersimpan!"));
        loadReport();
    }

    function loadReport() {
        fetch('api.php?action=get_revenue_report').then(r=>r.json()).then(d => {
            // Set Input Harga
            document.getElementById('inputRate').value = d.rate;
            
            // Render Tabel
            const list = document.getElementById('reportList');
            list.innerHTML = '';
            
            d.logs.forEach(log => {
                // Format Jam
                const time = log.timestamp.split(' ')[1].substring(0,5); 
                // Format Rupiah
                const rp = new Intl.NumberFormat('id-ID').format(log.amount);
                
                list.innerHTML += `
                    <tr style="border-bottom:1px solid #222;">
                        <td>${time}</td>
                        <td>${log.minutes} mnt</td>
                        <td>${log.note}</td>
                        <td style="text-align:right;">${rp}</td>
                    </tr>
                `;
            });

            // Total
            document.getElementById('totalRevenue').innerText = "Rp " + new Intl.NumberFormat('id-ID').format(d.total);
            document.getElementById('todayDate').innerText = new Date().toLocaleDateString('id-ID');
        });
    }
    
    // Load saat buka
    loadReport();
    </script>





<script>
    // Load Settings saat buka
    fetch('api.php?action=get_settings').then(r=>r.json()).then(d => {
        if(d.bg_url) document.getElementById('bg_url').value = d.bg_url;
        if(d.yt_api_key) document.getElementById('yt_api_key').value = d.yt_api_key;
        if(d.license_key) document.getElementById('license_key').value = d.license_key;
    });

    function save(key) {
        const val = document.getElementById(key).value;
        const fd = new FormData();
        fd.append('action', 'save_setting');
        fd.append('key', key);
        fd.append('val', val);
        fetch('api.php', { method: 'POST', body: fd }).then(r=>r.json()).then(() => alert("Pengaturan Tersimpan!"));
    }

    // FUNGSI GANTI PASSWORD
    function changePass() {
        const val = document.getElementById('new_pass').value;
        if(!val) return alert("Password tidak boleh kosong!");
        
        const fd = new FormData();
        fd.append('action', 'change_password');
        fd.append('new_pass', val);

        fetch('api.php', { method: 'POST', body: fd }).then(r=>r.json()).then(res => {
            if(res.status === 'success') {
                alert("Password berhasil diubah! Silakan login ulang.");
                document.getElementById('new_pass').value = '';
            } else {
                alert("Gagal: " + res.msg);
            }
        });
    }

    function resetAll() {
        if(!confirm("YAKIN HAPUS SEMUA?\n- Semua lagu & playlist di database akan HILANG.\n- Koneksi folder akan diputus.\n\nTindakan ini tidak bisa dibatalkan!")) return;

        // 1. Reset Database MySQL
        fetch('api.php?action=reset_data')
        .then(r=>r.json())
        .then(async () => {
            // 2. Hapus IndexedDB (Memory Folder Browser)
            const req = indexedDB.deleteDatabase('KaraokeMultiDB');
            req.onsuccess = () => finishReset();
            req.onerror = () => finishReset();
            req.onblocked = () => finishReset();
        });
    }

    function finishReset() {
        alert("Sistem berhasil di-reset bersih!");
        location.href = 'index.php';
    }
    
    
    
    
    // FUNGSI BARU UNTUK TIMER
    function setTimer(forceVal) {
        let mins = (forceVal !== undefined) ? forceVal : document.getElementById('timer_minutes').value;
        if(mins === '') return alert("Masukkan angka menit!");

        const fd = new FormData();
        fd.append('action', 'set_timer');
        fd.append('minutes', mins);
        
        fetch('api.php', { method: 'POST', body: fd }).then(r=>r.json()).then(d => {
            alert("Timer berhasil di-set!");
        });
    }

    function addTimer() {
        let mins = document.getElementById('timer_minutes').value;
        if(mins === '') return alert("Masukkan angka menit untuk ditambahkan!");

        const fd = new FormData();
        fd.append('action', 'add_timer');
        fd.append('minutes', mins);
        
        fetch('api.php', { method: 'POST', body: fd }).then(r=>r.json()).then(d => {
            alert("Waktu berhasil ditambahkan!");
        });
    }
    
</script>

</body>
</html>