<?php
session_start();
include 'config_path.php';

// [PENTING] Izinkan browser membaca data audio untuk Visualizer (Waveform)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");

$base_folder = rtrim($SOURCE_FOLDER, '/\\') . DIRECTORY_SEPARATOR;
$id = (int)($_GET['id'] ?? 0);

if ($id > 0) {
    // Ambil info file dari database
    $q = mysqli_query($conn, "SELECT filepath FROM songs WHERE id = $id");
    if ($row = mysqli_fetch_assoc($q)) {
        $filename = $row['filepath'];
        $full_path = $base_folder . $filename;
        
        if (file_exists($full_path)) {
            $mime = mime_content_type($full_path);
            $size = filesize($full_path);
            
            // Header Standar Stream
            header("Content-Type: $mime");
            header("Content-Length: $size");
            header("Accept-Ranges: bytes");
            
            // Support Seek/Skip (Loncat menit)
            $fp = @fopen($full_path, 'rb');
            $start = 0; $end = $size - 1;

            if (isset($_SERVER['HTTP_RANGE'])) {
                $c_start = $start; $c_end = $end;
                list(, $range) = explode('=', $_SERVER['HTTP_RANGE'], 2);
                if (strpos($range, ',') !== false) {
                    header('HTTP/1.1 416 Requested Range Not Satisfiable');
                    header("Content-Range: bytes $start-$end/$size");
                    exit;
                }
                if ($range == '-') {
                    $c_start = $size - substr($range, 1);
                } else {
                    $range = explode('-', $range);
                    $c_start = $range[0];
                    $c_end = (isset($range[1]) && is_numeric($range[1])) ? $range[1] : $size;
                }
                $c_end = ($c_end > $end) ? $end : $c_end;
                if ($c_start > $c_end || $c_start > $size - 1 || $c_end >= $size) {
                    header('HTTP/1.1 416 Requested Range Not Satisfiable');
                    header("Content-Range: bytes $start-$end/$size");
                    exit;
                }
                $start = $c_start;
                $end = $c_end;
                $length = $end - $start + 1;
                fseek($fp, $start);
                header('HTTP/1.1 206 Partial Content');
                header("Content-Range: bytes $start-$end/$size");
                header("Content-Length: ".$length);
            }
            
            $buffer = 1024 * 8;
            while(!feof($fp) && ($p = ftell($fp)) <= $end) {
                if ($p + $buffer > $end) {
                    $buffer = $end - $p + 1;
                }
                set_time_limit(0);
                echo fread($fp, $buffer);
                flush();
            }
            fclose($fp);
            exit;
        }
    }
}
http_response_code(404);
?>