<?php
session_start();
if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Karaoke YouTube Online</title>
    <style>
    
    
    /* --- CINEMA MODE (FAKE FULLSCREEN) --- */
body.cinema-active .left-panel { flex: 100%; border: none; } /* Panel kiri full */
body.cinema-active .right-panel { display: none; } /* Panel kanan hilang */
body.cinema-active .search-area { display: none; } /* Pencarian hilang */
body.cinema-active .player-area { height: 100vh; border: none; } /* Player tinggi 100% layar */
/* Sembunyikan tombol back di mode cinema */
body.cinema-active .btn-back { display: none; }
    
    
    
        body { background: #121212; color: #ddd; font-family: sans-serif; display: flex; flex-direction: column; height: 100vh; margin:0; overflow:hidden; background-size: cover; background-position: center; }
        .overlay { background: rgba(0,0,0,0.85); position: absolute; top:0; left:0; width:100%; height:100%; z-index:-1; }
        
        .top-area { height: 60vh; background: black; border-bottom: 2px solid #d4af37; position: relative; }
        iframe { width: 100%; height: 100%; border: none; }
        
        .controls { flex: 1; padding: 20px; display: flex; flex-direction: column; gap: 10px; max-width: 800px; margin: 0 auto; width: 100%; }
        
        .search-box { display: flex; gap: 10px; }
        input { flex: 1; padding: 10px; background: #333; border: 1px solid #555; color: white; font-size: 16px; }
        button { padding: 10px 20px; cursor: pointer; font-weight: bold; border: none; border-radius: 4px; }
        .btn-search { background: #d4af37; color: black; }
        .btn-back { background: #444; color: white; }
        
        .results { flex: 1; overflow-y: auto; border: 1px solid #333; background: rgba(20,20,20,0.9); margin-top: 10px; }
        .item { display: flex; align-items: center; gap: 10px; padding: 10px; border-bottom: 1px solid #333; cursor: pointer; }
        .item:hover { background: #333; }
        .thumb { width: 120px; height: 68px; object-fit: cover; }
        
        
        
        
        /* UPDATE CSS UNTUK LAYOUT 2 KOLOM */
        .main-container { display: flex; height: 100vh; overflow: hidden; }
        .left-panel { flex: 2; display: flex; flex-direction: column; border-right: 1px solid #333; position: relative; }
        .right-panel { flex: 1; background: #1a1a1a; display: flex; flex-direction: column; min-width: 300px; max-width: 400px; }
        
        /* Player & Search di Kiri */
        .player-area { height: 50vh; background: black; border-bottom: 2px solid #d4af37; }
        .search-area { flex: 1; padding: 20px; overflow-y: auto; }
        
        /* Queue di Kanan */
        .queue-header { padding: 15px; background: #222; border-bottom: 1px solid #d4af37; color: #d4af37; font-weight: bold; display:flex; justify-content:space-between; align-items:center; }
        .queue-list { flex: 1; overflow-y: auto; padding: 10px; }
        .q-item { background: #2a2a2a; padding: 8px; margin-bottom: 5px; border-left: 3px solid #555; display: flex; justify-content: space-between; font-size: 13px; }
        .q-item:hover { background: #333; border-left-color: gold; }
        .q-title { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; max-width: 200px; cursor: pointer;}
        
        /* Override style lama yang bentrok */
        body { flex-direction: row; } 
        iframe { width: 100%; height: 100%; border: none; }
        .btn-add { background: #2e7d32; color: white; border:none; padding: 5px 10px; cursor: pointer; border-radius: 4px; font-size: 10px; margin-left: 10px;}
        .btn-del { background: #c62828; color: white; border:none; padding: 2px 6px; cursor: pointer; margin-left:5px;}
        
        
        /* UPDATE CSS PANEL KANAN TERBAGI 2 */
        .right-panel { flex: 1; background: #1a1a1a; display: flex; flex-direction: column; min-width: 320px; max-width: 400px; border-left: 1px solid #333; }
        
        /* Area Playlist Tersimpan (Atas) */
        .saved-area { height: 40%; border-bottom: 2px solid #d4af37; display: flex; flex-direction: column; }
        .saved-list { flex: 1; overflow-y: auto; background: #222; }
        .playlist-item { padding: 8px 10px; border-bottom: 1px solid #333; cursor: pointer; color: #ccc; font-size: 13px; display: flex; justify-content: space-between; }
        .playlist-item:hover { background: #333; color: gold; }

        /* Area Antrian Lagu (Bawah) */
        .queue-area { flex: 1; display: flex; flex-direction: column; background: #151515; }
        .queue-header { padding: 10px; background: #000; color: #d4af37; font-weight: bold; border-bottom: 1px solid #333; display: flex; justify-content: space-between; align-items: center; font-size: 14px; }
        .queue-list { flex: 1; overflow-y: auto; padding: 5px; }
        
        
    </style>
</head>
<body>
    
    <div id="marqueeContainer" style="display:none; position:fixed; top:0; left:0; width:100%; background:rgba(0,0,0,0.8); color:#d4af37; z-index:99990; font-weight:bold; font-size:24px; padding:10px 0; border-bottom:2px solid gold; overflow:hidden; white-space:nowrap; pointer-events:none;">
    <div id="marqueeText" style="display:inline-block; padding-left:100%; animation: scroll-text 15s linear infinite;">
        Selamat Datang di Karaoke Kami!
    </div>
</div>

<style>
@keyframes scroll-text {
    0% { transform: translateX(0); }
    100% { transform: translateX(-100%); }
}
/* Pastikan Marquee tetap di atas elemen lain */
body.cinema-active #marqueeContainer { display: block !important; } 
</style>
    
    
    <div class="overlay"></div>

    <div class="left-panel">
        <div class="player-area" style="position:relative; background:black;">
            <div id="ytPlayer"></div>

            <div style="position:absolute; bottom:10px; right:10px; background:rgba(0,0,0,0.7); padding:5px 10px; border-radius:5px; display:flex; align-items:center; gap:10px;">
                <span style="color:white; font-size:12px;">🔊 VOL</span>
                <input type="range" id="volSlider" min="0" max="100" value="100" oninput="setVolume(this.value)" style="width:100px; cursor:pointer;">
                <span id="volText" style="color:#d4af37; font-size:11px; font-weight:bold; width:30px;">100%</span>
            </div>
        </div>

        <div class="search-area">
            <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px;">
                <button class="btn-back" onclick="location.href='index.php'">⬅ MENU UTAMA</button>
                <h3 style="margin:0; color:#d4af37;">PENCARIAN YOUTUBE</h3>
            </div>

            <div class="search-box">
                <input type="text" id="query" placeholder="Ketik Judul Lagu / Artis..." style="width:100%">
                <button class="btn-search" onclick="searchYT()">CARI</button>
            </div>

            <div class="results" id="resList" style="margin-top:15px;">
                <div style="text-align:center; color:#777;">Hasil pencarian muncul disini...</div>
            </div>
        </div>
    </div>

    
      <div class="right-panel">
        
        <div class="saved-area">
            <div style="padding:10px; background:#111; color:white; font-weight:bold; font-size:12px; border-bottom:1px solid #444;">
                📂 PLAYLIST TERSIMPAN
                <button onclick="loadSavedPlaylists()" style="float:right; border:none; background:none; color:gold; cursor:pointer;">🔄</button>
            </div>
            <div id="savedPlaylists" class="saved-list">
                <div style="padding:10px; color:#555; text-align:center;">Memuat...</div>
            </div>
        </div>

        <div class="queue-area">
            <div class="queue-header">
                <span>🎵 DAFTAR LAGU</span>
                <div>
                    <button onclick="saveQueue()" style="background:#d4af37; border:none; padding:4px 8px; font-weight:bold; cursor:pointer; font-size:11px; border-radius:3px;">💾 SIMPAN BARU</button>
                    <button onclick="clearQueue()" style="background:#c62828; border:none; padding:4px 8px; color:white; cursor:pointer; font-size:11px; border-radius:3px;">🗑️</button>
                </div>
            </div>
            <div id="queueList" class="queue-list">
                </div>
        </div>

    </div>
<script>
    // --- VARIABEL GLOBAL ---
    let player; // Object Player YouTube API
    let apiKey = ''; 
    let queue = []; 
    let currentIdx = -1; // [BARU] Melacak urutan lagu yang sedang diputar

    // --- 1. INISIALISASI SAAT LOAD ---
    window.onload = function() {
        loadSettings();
        loadSavedPlaylists();
        renderQueue(); 

        var tag = document.createElement('script');
        tag.src = "https://www.youtube.com/iframe_api";
        var firstScriptTag = document.getElementsByTagName('script')[0];
        firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
    };

    function loadSettings() {
        fetch('api.php?action=get_settings').then(r=>r.json()).then(d => {
            if(d.bg_url) document.body.style.backgroundImage = `url('${d.bg_url}')`;
            if(d.yt_api_key) apiKey = d.yt_api_key;
            else alert("API Key YouTube belum diisi!");
        });
    }

    function onYouTubeIframeAPIReady() {
        player = new YT.Player('ytPlayer', {
            height: '100%',
            width: '100%',
            videoId: '',
            playerVars: { 'playsinline': 1, 'autoplay': 1, 'controls': 1, 'rel': 0 },
            events: {
                'onReady': onPlayerReady,
                'onStateChange': onPlayerStateChange
            }
        });
    }

    function onPlayerReady(event) {
        const vol = document.getElementById('volSlider').value;
        event.target.setVolume(vol);
    }

    // [BARU] Auto Next saat lagu selesai
    function onPlayerStateChange(event) {
        if (event.data === YT.PlayerState.ENDED) {
            playNext(); // Panggil fungsi next otomatis
        }
    }

    // --- 3. FUNGSI KONTROL UTAMA ---
    
    // [UPDATE] Play sekarang menerima Index (urutan), bukan cuma ID
    function playByIndex(idx) {
        if(idx < 0 || idx >= queue.length) return;
        currentIdx = idx;
        renderQueue(); // Update tampilan (agar yang aktif berwarna beda)
        
        const item = queue[idx];
        if(player && player.loadVideoById) {
            player.loadVideoById(item.videoId);
        }
    }

    // Fungsi lama untuk kompatibilitas klik mouse manual
    function play(videoId) {
        // Cari index dari videoId ini
        const foundIdx = queue.findIndex(item => item.videoId === videoId);
        if(foundIdx !== -1) {
            playByIndex(foundIdx);
        } else {
            // Jika diputar dari hasil pencarian (belum masuk antrian)
            if(player && player.loadVideoById) player.loadVideoById(videoId);
        }
    }
    
    // [BARU] Fungsi Next
    function playNext() {
        if(queue.length === 0) return;
        let nextIdx = currentIdx + 1;
        if(nextIdx >= queue.length) nextIdx = 0; // Loop ke awal jika habis
        playByIndex(nextIdx);
    }

    function setVolume(val) {
        if(player && player.setVolume) {
            player.setVolume(val);
            document.getElementById('volText').innerText = val + "%";
        }
    }

    // --- 4. PENCARIAN & QUEUE ---
    document.getElementById('query').addEventListener('keypress', function (e) {
        if (e.key === 'Enter') searchYT();
    });

    async function searchYT() {
        const q = document.getElementById('query').value;
        if(!q) return;
        if(!apiKey) return alert("Error: API Key Kosong.");

        const div = document.getElementById('resList');
        div.innerHTML = '<div>Sedang mencari...</div>';

        try {
            const url = `https://www.googleapis.com/youtube/v3/search?part=snippet&maxResults=20&q=${encodeURIComponent(q + " karaoke")}&type=video&key=${apiKey}`;
            const res = await fetch(url);
            const data = await res.json();
            if(data.error) throw new Error(data.error.message);

            div.innerHTML = '';
            data.items.forEach(item => {
                const vidId = item.id.videoId;
                const title = item.snippet.title;
                const thumb = item.snippet.thumbnails.default.url;

                const el = document.createElement('div');
                el.className = 'item';
                el.innerHTML = `
                    <img src="${thumb}" class="thumb" onclick="play('${vidId}')">
                    <div style="flex:1; padding:0 10px;">
                        <div style="font-weight:bold; color:#fff; cursor:pointer;" onclick="play('${vidId}')">${title}</div>
                        <div style="font-size:12px; color:#aaa">${item.snippet.channelTitle}</div>
                    </div>
                    <button class="btn-add" onclick="addToQueue('${vidId}', \`${title.replace(/'/g, "")}\`)">➕ ANTRIAKAN</button>
                `;
                div.appendChild(el);
            });
        } catch (e) {
            div.innerHTML = `<div style="color:red;">Gagal: ${e.message}</div>`;
        }
    }

    // --- 5. LOGIKA PLAYLIST ---
    function addToQueue(vidId, title) {
        // Cek apakah videoId sudah ada di antrian?
        const isDuplicate = queue.some(item => item.videoId === vidId);
        
        if (isDuplicate) {
            // Tampilkan notifikasi kecil atau console log, jangan alert agar tidak mengganggu playback
            console.log("Video sudah ada di playlist (Skip duplicate)");
            return; 
        }

        queue.push({ videoId: vidId, title: title });
        renderQueue();
    }

    function renderQueue() {
        const div = document.getElementById('queueList');
        div.innerHTML = '';
        queue.forEach((item, idx) => {
            const el = document.createElement('div');
            // [UPDATE] Tambahkan class 'active' jika sedang diputar
            el.className = 'q-item ' + (idx === currentIdx ? 'active-song' : ''); 
            // Style inline tambahan untuk penanda aktif
            if(idx === currentIdx) el.style.borderLeft = "3px solid #00e676"; 
            
            el.innerHTML = `
                <div class="q-title" onclick="playByIndex(${idx})">${idx+1}. ${item.title}</div>
                <button class="btn-del" onclick="removeFromQueue(${idx})">×</button>
            `;
            div.appendChild(el);
        });
    }

    function removeFromQueue(idx) {
        queue.splice(idx, 1);
        if(currentIdx >= idx) currentIdx--; // Geser index jika lagu sebelumnya dihapus
        renderQueue();
    }

    function saveQueue() {
    if(queue.length === 0) return alert("Antrian kosong!");

    let actionName = 'save_playlist';
    let plName = '';
    let plId = 0;

    if (currentLoadedPlId) {
        if (confirm("UPDATE Playlist YouTube ini?\nOK = Update\nCancel = Simpan Baru")) {
            actionName = 'update_playlist';
            plId = currentLoadedPlId;
        } else {
            plName = prompt("Nama Playlist BARU:");
            if(!plName) return;
            currentLoadedPlId = null;
        }
    } else {
        plName = prompt("Beri Nama Playlist YouTube ini:");
        if(!plName) return;
    }

    const fd = new FormData();
    fd.append('action', actionName);
    if (actionName === 'save_playlist') fd.append('name', plName);
    if (actionName === 'update_playlist') fd.append('id', plId);
    fd.append('type', 'youtube'); 
    fd.append('songs', JSON.stringify(queue)); 

    fetch('api.php', { method: 'POST', body: fd }).then(r => r.json()).then(d => {
        if(d.status === 'success') { 
            alert("Tersimpan!"); 
            loadSavedPlaylists(); 
        } else alert("Gagal: " + d.msg);
    });
}

    function loadSavedPlaylists() {
        const div = document.getElementById('savedPlaylists');
        fetch('api.php?action=get_playlists&type=youtube').then(r => r.json()).then(data => {
            div.innerHTML = '';
            if(data.length === 0) {
                div.innerHTML = '<div style="padding:10px; color:#555; text-align:center; font-size:11px;">Belum ada playlist YouTube.</div>';
                return;
            }
            data.forEach(p => {
                const el = document.createElement('div');
                el.className = 'playlist-item';
                el.innerHTML = `<span>💿 ${p.name}</span> <span style="font-size:10px; color:#666;">Load ▶</span>`;
                el.onclick = () => loadPlaylistItems(p.id, p.name);
                div.appendChild(el);
            });
        });
    }

    function loadPlaylistItems(pid, pname) {
        if(!confirm(`Buka playlist "${pname}"?`)) return;
        fetch('api.php?action=load_playlist_items&id=' + pid).then(r => r.json()).then(items => {
            currentLoadedPlId = pid;
            queue = items.map(item => ({ videoId: item.videoId, title: item.title }));
            currentIdx = -1; // Reset index
            renderQueue();
            if(queue.length > 0) playByIndex(0); // Putar lagu pertama
        });
    }

    function clearQueue() {
    if(confirm("Bersihkan antrian?")) { 
        queue = []; 
        currentIdx = -1; 
        currentLoadedPlId = null; // Reset ID
        renderQueue(); 
    }
}

    // --- REMOTE POLLING ---
    setInterval(() => {
        fetch('api.php?action=remote_poll').then(r=>r.json()).then(d => {
            if(d.status === 'command') executeYTRemote(d.cmd, d.val);
        });
    }, 1000);

   // [PENTING] FUNGSI REMOTE YOUTUBE DENGAN LOGIKA LOAD PLAYLIST
    function executeYTRemote(cmd, val) {
        if(!player || typeof player.playVideo !== 'function') return;

        if(cmd === 'play') player.playVideo();
        if(cmd === 'pause') player.pauseVideo();
        if(cmd === 'volume') player.setVolume(val);
        if(cmd === 'next') playNext();
        if(cmd === 'mode_local') location.href = 'index.php';
        if(cmd === 'fullscreen') document.body.classList.toggle('cinema-active');

        // Play Direct (Tombol Play Merah di Remote)
        if(cmd === 'play_yt_direct') {
            player.loadVideoById(val);
            // Opsional: Jika ingin otomatis masuk list
            // addToQueue(val, "Remote Selection");
        }

        // Add Queue dari Remote (Tombol Tambah Hijau)
        if(cmd === 'queue_add_yt') {
            try {
                // Remote mengirim JSON string: {"id":"...", "title":"..."}
                const data = JSON.parse(val);
                addToQueue(data.id, data.title);
            } catch(e) {
                console.error("Gagal parse data remote", e);
            }
        }

        // Load Playlist & Jump
        if(cmd === 'load_pl_jump') {
            const parts = val.split('|'); 
            const plId = parts[0];
            const jumpIdx = parseInt(parts[1]);

            fetch('api.php?action=load_playlist_items&id=' + plId).then(r => r.json()).then(items => {
                queue = items.map(item => ({ videoId: item.videoId, title: item.title }));
                currentIdx = -1;
                renderQueue();
                // Langsung putar index yang dipilih
                if(queue.length > jumpIdx) playByIndex(jumpIdx);
            });
        }
        
        // Load Full Playlist
        if(cmd === 'load_pl') {
            fetch('api.php?action=load_playlist_items&id=' + val).then(r => r.json()).then(items => {
                currentLoadedPlId = val;
                queue = items.map(item => ({ videoId: item.videoId, title: item.title }));
                currentIdx = -1;
                renderQueue();
                if(queue.length > 0) playByIndex(0);
            });
        }
    

        if(cmd === 'mode_local') location.href = 'index.php';
        
        if(cmd === 'fullscreen') {
            document.body.classList.toggle('cinema-active');
        }
    }
    
    // FUNGSI CINEMA MODE (Pengganti Fullscreen yang diblokir browser)
    function toggleCinemaMode() {
        const body = document.body;
        // Tambahkan class khusus ke body
        body.classList.toggle('cinema-active');
    }
</script>




<div id="billingOverlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:black; z-index:99999; flex-direction:column; justify-content:center; align-items:center; color:white; text-align:center;">
    <h1 style="font-size:50px; color:red; margin:0;">WAKTU HABIS</h1>
    <p>Silakan hubungi Admin/Kasir untuk menambah waktu.</p>
</div>

<div id="marqueeContainer" style="display:none; position:fixed; top:0; left:0; width:100%; background:rgba(0,0,0,0.8); color:#d4af37; z-index:99990; font-weight:bold; font-size:24px; padding:10px 0; border-bottom:2px solid gold; overflow:hidden; white-space:nowrap; pointer-events:none;">
    <div id="marqueeText" style="display:inline-block; padding-left:100%; animation: scroll-text 15s linear infinite;">
        Selamat Datang di Karaoke Kami!
    </div>
</div>

<style>
@keyframes scroll-text {
    0% { transform: translateX(0); }
    100% { transform: translateX(-100%); }
}
/* Pastikan Marquee tetap di atas elemen lain */
body.cinema-active #marqueeContainer { display: block !important; } 
</style>

<div id="billingOverlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:black; z-index:99999; flex-direction:column; justify-content:center; align-items:center; color:white; text-align:center;">
    <h1 style="font-size:50px; color:red; margin:0;">WAKTU HABIS</h1>
    <p>Silakan hubungi Admin/Kasir untuk menambah waktu.</p>
</div>

<script>
    // Ganti interval lama dengan fungsi baru ini
    setInterval(updatePlayerInfo, 5000);

    function updatePlayerInfo() {
        // Panggil API 'get_player_info' (bukan check_timer_status lagi)
        fetch('api.php?action=get_player_info')
        .then(r => r.json())
        .then(data => {
            // 1. UPDATE TIMER (Overlay Hitam)
            const overlay = document.getElementById('billingOverlay');
            
            // Cek status timer
            if (data.timer_status === 'expired') {
                if (overlay.style.display === 'none') {
                    overlay.style.display = 'flex';
                    if(player && typeof player.pauseVideo === 'function') {
                        player.pauseVideo(); // Matikan Youtube
                    }
                }
            } else {
                overlay.style.display = 'none';
            }

            // 2. UPDATE RUNNING TEXT
            const mq = document.getElementById('marqueeContainer');
            const txt = document.getElementById('marqueeText');
            
            // Cek apakah ada pesan teks
            if(data.running_text && data.running_text.trim() !== "") {
                // Update teks hanya jika berubah (biar tidak kedip)
                if(txt.innerText !== data.running_text) txt.innerText = data.running_text;
                mq.style.display = 'block'; // Munculkan
            } else {
                mq.style.display = 'none'; // Sembunyikan jika kosong
            }
        })
        .catch(e => console.log("Player Info Error: " + e));
    }
    
    // Jalankan sekali saat halaman terbuka
    updatePlayerInfo();
</script>


</body>
</html>